/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.delete;

import android.support.annotation.NonNull;
import com.pushtorefresh.storio.internal.Checks;
import java.util.Collections;
import java.util.Set;

public final class DeleteResult {
    private final int numberOfRowsDeleted;
    @NonNull
    private final Set<String> affectedTables;

    private DeleteResult(int numberOfRowsDeleted, @NonNull Set<String> affectedTables) {
        Checks.checkNotNull(affectedTables, (String)"Please specify affected tables");
        this.numberOfRowsDeleted = numberOfRowsDeleted;
        this.affectedTables = Collections.unmodifiableSet(affectedTables);
    }

    @NonNull
    public static DeleteResult newInstance(int numberOfRowsDeleted, @NonNull Set<String> affectedTables) {
        Checks.checkNotNull(affectedTables, (String)"Please specify affected tables");
        return new DeleteResult(numberOfRowsDeleted, affectedTables);
    }

    @NonNull
    public static DeleteResult newInstance(int numberOfRowsDeleted, @NonNull String affectedTable) {
        Checks.checkNotNull((Object)affectedTable, (String)"Please specify affected table");
        return new DeleteResult(numberOfRowsDeleted, Collections.singleton(affectedTable));
    }

    public int numberOfRowsDeleted() {
        return this.numberOfRowsDeleted;
    }

    @NonNull
    public Set<String> affectedTables() {
        return this.affectedTables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteResult that = (DeleteResult)o;
        if (this.numberOfRowsDeleted != that.numberOfRowsDeleted) {
            return false;
        }
        return this.affectedTables.equals(that.affectedTables);
    }

    public int hashCode() {
        int result = this.numberOfRowsDeleted;
        result = 31 * result + this.affectedTables.hashCode();
        return result;
    }

    public String toString() {
        return "DeleteResult{numberOfRowsDeleted=" + this.numberOfRowsDeleted + ", affectedTables=" + this.affectedTables + '}';
    }
}

