/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.TypeMappingFinder;
import com.pushtorefresh.storio.internal.TypeMapping;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TypeMappingFinderImpl
implements TypeMappingFinder {
    @Nullable
    private Map<Class<?>, ? extends TypeMapping<?>> directTypeMapping;
    @NonNull
    private final Map<Class<?>, TypeMapping<?>> indirectTypesMappingCache = new ConcurrentHashMap();

    @Override
    @Nullable
    public <T> TypeMapping<T> findTypeMapping(@NonNull Class<T> type) {
        TypeMapping<T> typeMapping;
        TypeMapping<?> typeMapping2;
        if (this.directTypeMapping == null) {
            return null;
        }
        TypeMapping<T> directOrCachedMapping = this.getDirectOrCachedTypeMapping(type, this.directTypeMapping);
        if (directOrCachedMapping != null) {
            return directOrCachedMapping;
        }
        Class<T> parentType = type.getSuperclass();
        if (parentType != null && parentType != Object.class && (typeMapping2 = this.directTypeMapping.get(parentType)) != null) {
            this.indirectTypesMappingCache.put(type, typeMapping2);
            return typeMapping2;
        }
        for (Class<?> ownInterface : type.getInterfaces()) {
            TypeMapping<?> mappingOfInterface = this.directTypeMapping.get(ownInterface);
            if (mappingOfInterface == null) continue;
            this.indirectTypesMappingCache.put(type, mappingOfInterface);
            return mappingOfInterface;
        }
        if (parentType != null && parentType != Object.class && (typeMapping = this.findTypeMapping(parentType)) != null) {
            this.indirectTypesMappingCache.put(type, typeMapping);
            return typeMapping;
        }
        for (Class<?> ownInterface : type.getInterfaces()) {
            TypeMapping<?> mappingOfInterfaces = this.findTypeMapping(ownInterface);
            if (mappingOfInterfaces == null) continue;
            this.indirectTypesMappingCache.put(type, mappingOfInterfaces);
            return mappingOfInterfaces;
        }
        return null;
    }

    @Nullable
    private <T> TypeMapping<T> getDirectOrCachedTypeMapping(@NonNull Class<T> type, @NonNull Map<Class<?>, ? extends TypeMapping<?>> directMappingMap) {
        TypeMapping<?> directMapping = directMappingMap.get(type);
        if (directMapping != null) {
            return directMapping;
        }
        TypeMapping<?> cachedMapping = this.indirectTypesMappingCache.get(type);
        if (cachedMapping != null) {
            return cachedMapping;
        }
        return null;
    }

    @Override
    public void directTypeMapping(@Nullable Map<Class<?>, ? extends TypeMapping<?>> directTypeMapping) {
        this.directTypeMapping = directTypeMapping;
    }

    @Override
    @Nullable
    public Map<Class<?>, ? extends TypeMapping<?>> directTypeMapping() {
        return this.directTypeMapping;
    }
}

