package com.pushpole.sdk.util;

import android.os.Bundle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.pushpole.sdk.Constants;

/***
 * A helper class to convert {@link Pack} object to {@link Bundle} object, and vice versa
 */
public class PackBundler {
    /***
     * Convert {@link Pack} object to {@link Bundle} object
     *
     * @param pack the {@link Pack} object
     * @return the {@link Bundle} object
     */
    public static Bundle packToBundle(Pack pack) {
        Bundle bundle = new Bundle();

        List<String> jsonKeys = new ArrayList<>();
        for (String key : pack.keySet()) {
            Object value = pack.get(key);
            if (value instanceof Pack) {
                bundle.putString(key, ((Pack) value).toJson());
                //jsonKeys.add(key);
            } else if (value instanceof ListPack) {
                bundle.putString(key, ((ListPack) value).toJson());
                //jsonKeys.add(key);
            } else {
                bundle.putString(key, String.valueOf(value));
            }
            try{
                if(key != null && !key.isEmpty()) {
                    Integer.parseInt(key.substring(1));
                    jsonKeys.add(key);
                }
            }catch ( NumberFormatException e){

            }
        }

        ListPack jsonKeyPack = new ListPack(jsonKeys);
        bundle.putString(Constants.getVal(Constants.F_JSON_KEYS), jsonKeyPack.toJson());

        return bundle;
    }

    public static Map<String, String> packToStringMap(Pack pack) {
        Map<String, String> data = new HashMap<>();

        List<String> jsonKeys = new ArrayList<>();
        for (String key : pack.keySet()) {
            Object value = pack.get(key);
            if (value instanceof Pack) {
                data.put(key, ((Pack) value).toJson());
                //jsonKeys.add(key);
            } else if (value instanceof ListPack) {
                data.put(key, ((ListPack) value).toJson());
                //jsonKeys.add(key);
            } else {
                data.put(key, String.valueOf(value));
            }
            try{
                if(key != null && !key.isEmpty()) {
                    Integer.parseInt(key.substring(1));
                    jsonKeys.add(key);
                }
            }catch ( NumberFormatException e){

            }
        }

        ListPack jsonKeyPack = new ListPack(jsonKeys);
        data.put(Constants.getVal(Constants.F_JSON_KEYS), jsonKeyPack.toJson());

        return data;
    }

    /***
     * convert {@link Bundle} object to {@link Pack} object
     *
     * @param bundle the {@link Bundle} object
     * @return the {@link Pack} object
     */
    public static Pack bundleToPack(Bundle bundle) {
        Pack pack = new Pack();

        for (String key : bundle.keySet()) {
            Object value = bundle.get(key);

            String strVal = String.valueOf(value);
            try {
                if (strVal.trim().startsWith("{") && strVal.trim().endsWith("}")) {
                    pack.putPack(key, Pack.fromJson(strVal));
                } else if (strVal.trim().startsWith("[") && strVal.trim().endsWith("]")) {
                    pack.putListPack(key, ListPack.fromJson(strVal));
                } else {
                    pack.putString(key, strVal);
                }
            } catch (InvalidJsonException e) {
                pack.putString(key, strVal);
            }
        }

        return pack;
    }

    public static Pack stringMapToPack(Map<String, String> map) {
        Pack pack = new Pack();

        for (String key : map.keySet()) {
            Object value = map.get(key);

            String strVal = String.valueOf(value);
            try {
                if (strVal.trim().startsWith("{") && strVal.trim().endsWith("}")) {
                    pack.putPack(key, Pack.fromJson(strVal));
                } else if (strVal.trim().startsWith("[") && strVal.trim().endsWith("]")) {
                    pack.putListPack(key, ListPack.fromJson(strVal));
                } else {
                    pack.putString(key, strVal);
                }
            } catch (InvalidJsonException e) {
                pack.putString(key, strVal);
            }
        }

        return pack;
    }
}
