package com.pushpole.sdk.task;

import android.content.Context;

import java.util.UUID;

import com.pushpole.sdk.util.Pack;

/***
 * Asynchronous task entity that can be schedule to run on {@link com.pushpole.sdk.service.IntentTaskRunner}
 */
public abstract class PushPoleAsyncTask implements PushPoleTask {
    private String mId;

    /***
     * constructor
     * set task random id
     */
    public PushPoleAsyncTask() {
        setId(UUID.randomUUID().toString().substring(0, 10));
    }

    /***
     * run task
     *
     * @param context the app context
     */
    public abstract void run(Context context);


    /***
     * run task
     *
     * @param context the app context
     * @param data    the data
     * @return {@code RESULT_SUCCESS}
     */
    //TODO - the data parameter is useless
    @Override
    public Result runTask(Context context, Pack data) {
        run(context);
        return Result.SUCCESS;
    }

    /***
     * return task ID
     *
     * @return the unique ID
     */
    public String getId() {
        return mId;
    }

    /***
     * set task ID
     *
     * @param id the unique ID
     */
    public void setId(String id) {
        mId = id;
    }
}
