package com.pushpole.sdk.service;

import android.app.Service;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.IBinder;
import android.support.annotation.Nullable;

import com.pushpole.sdk.receiver.BootAndScreenReceiver;

/**
 * Created on 16-07-04, 10:40 AM.
 *
 * @author Akram Shokri
 */
public class ScreenStateService extends Service {

    private BootAndScreenReceiver mReceiver;

    @Override
    public void onCreate() {
        super.onCreate();

        IntentFilter filter = new IntentFilter(Intent.ACTION_SCREEN_ON);
        filter.addAction(Intent.ACTION_SCREEN_OFF);
        mReceiver = new BootAndScreenReceiver();
        registerReceiver(mReceiver, filter);

        //initializing evernote's jobManager in service to avoid crash when app is closed.
        //if below initialization is removed PushPole.initialize needs to be placed in Application.onCreate
//        JobManager.create(getApplicationContext()).addJobCreator(new EvernoteScheduler(getApplicationContext()));//FIXME
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void onDestroy() {
        if (mReceiver != null)
            unregisterReceiver(mReceiver);
        super.onDestroy();
    }
}
