package com.pushpole.sdk.service;

import android.app.IntentService;
import android.content.Intent;


import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.SenderInfo;
import com.pushpole.sdk.internal.log.ExceptionCatcher;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.network.GcmHandler;
import com.pushpole.sdk.task.TaskManager;

/***
 * A service to run general tasks
 */
public class IntentTaskRunner extends IntentService {
    private final static String F_FROM = "from";
    private final static String F_REGISTRATION_ID = "registration_id";
    private final static String F_MESSAGE_ID = "google.message_id";
    private final static String F_ERROR = "error";

    private GcmHandler mGcmHandler;

    public IntentTaskRunner() {
        super("PushPoleIntentService");
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        Logger.initialize(this);
        ExceptionCatcher.makePushPoleDefaultExceptionCatcher(this);
        try {
            if (intent != null) {
                String action = intent.getAction();
                if (PlainConstants.ACTION_RUN_TASK.equals(action)) {
                    TaskManager.getInstance(this).handleAsyncTask(intent);
                } else if (
                        Constants.getVal(Constants.ACTION_GCM_REGISTER).equals(action)
                        ) {
                    // TODO - why this line is commented !!?
                    //            handleGcmRegisterIntent(intent);
                } else if (Constants.getVal(Constants.ACTION_GCM_RECEIVE).equals(action)) {
//                    handleGcmReceiveMessage(intent);
                    Logger.error("Action GCM_RECEIVE received, this should not happen");
                }
            }
        } catch (Throwable t) {
            Logger.error("Error in executing onHandleIntent of IntentTaskRunner ", t, new LogData("Action", "Action is : " + intent.getAction()));
        }
    }

    // TODO - what is the usage of this method
    private void handleGcmRegisterIntent(Intent intent) {
        String registrationId = intent.getStringExtra(F_REGISTRATION_ID);
        if (registrationId != null && !registrationId.isEmpty()) {
            SenderInfo.getInstance(this).setToken(this, registrationId);
            SenderInfo.getInstance(this).setTokenState(this, SenderInfo.TOKEN_RECEIVED);
        }
    }

    public GcmHandler getGcmHandler() {
        if (mGcmHandler == null) {
            mGcmHandler = new GcmHandler(this);
        }
        return mGcmHandler;
    }
}
