package com.pushpole.sdk.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.pushpole.sdk.SenderInfo;
import com.pushpole.sdk.controller.controllers.RegisterController;
import com.pushpole.sdk.internal.log.ExceptionCatcher;
import com.pushpole.sdk.internal.log.Logger;

/***
 * A broadcast receiver to invalid current GCM registration and re-register to it when app updated.
 */
public class UpdateReceiver extends BroadcastReceiver {
    /***
     * Re-register to GCM and PushPole-server
     *
     * @param context
     * @param intent
     */
    @Override
    public void onReceive(Context context, Intent intent) {
        try {
            if (intent.getAction().equals("android.intent.action.PACKAGE_REPLACED") &&
              intent.getData().getSchemeSpecificPart().equals(context.getPackageName())){//This condition is for making sure its our packeage being updated
                    RegisterController registerCtrl = new RegisterController(context);
                    Logger.info("UpdateReceiver: Package updated, invalidating FCM token and re-registering to FCM and PushPole-Server");
                    registerCtrl.invalidateRegistration(); //this method is called in 'needsRegistration()' too, but calling it again won't hurt!, in case the former call was not made due to exception
                    registerCtrl.register();
                    SenderInfo.updateSenderIdInKeystore(); //to take care of changing senderId in manifest
            }
        } catch (Exception e) {
            ExceptionCatcher.getInstance(context).catchException(e);
        }
    }
}
