package com.pushpole.sdk.message.upstream;

import android.content.Context;

import java.util.ArrayList;
import java.util.List;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.device.ApplicationDetails;
import com.pushpole.sdk.util.ListPack;
import com.pushpole.sdk.util.Pack;

/***
 * A class that represent upstream message for syncing app with pushpole-server
 * the message contains data about client's device from certain time
 */
public class SyncApplicationsUpstreamMessage extends UpstreamMessage {
    private List<ApplicationDetails> mApplicationList;
    //private long mToDate;
    //private long mFromDate;

    public List<ApplicationDetails> getApplicationList() {
        return mApplicationList;
    }

    /***
     * set applications list
     *
     * @param applicationList apps list
     */
    public void setApplicationList(List<ApplicationDetails> applicationList) {
        mApplicationList = applicationList;
    }

    /***
     * store {@link SyncApplicationsUpstreamMessage} data in to a {@link Pack} object
     *
     * @return the {@link Pack} object
     */
    @Override
    public Pack toPack() {
        ListPack appListPack = new ListPack();

        if (mApplicationList != null) {
            for (ApplicationDetails app : mApplicationList) {
                Pack appPack = app.toPack();
                //appPack.remove(Constants.F_APP_PACKAGENAME);
                appListPack.addPack(appPack);
            }
        }

        final Pack upstreamPack = super.toPack();
        upstreamPack.putListPack(Constants.getVal(Constants.APP_LIST_T), appListPack);
        return upstreamPack;
    }

    /***
     * return message type
     *
     * @return {@code Type.SYNC_APPS}
     */
    @Override
    public UpstreamMessage.Type getMessageType() {
        return Type.SYNC_APPS;
    }

    /***
     * Factory class for generating {@link SyncApplicationsUpstreamMessage} instance
     */
    public static class Factory extends UpstreamMessageFactory {

        /***
         * generate {@link SyncApplicationsUpstreamMessage} instance
         *
         * @param data the pack that contains data for populating message
         * @return {@link SyncApplicationsUpstreamMessage} instance
         */
        @Override
        public UpstreamMessage buildMessage(Pack data) {
            SyncApplicationsUpstreamMessage message = new SyncApplicationsUpstreamMessage();
            populateMessage(message, data);

            ListPack appPacks = data.getListPack(Constants.getVal(Constants.APP_LIST_T), null);
            if (appPacks != null) {
                List<ApplicationDetails> appList = new ArrayList<>();

                //for (String key : appPacks.keySet()) {
                for (int i = 0; i < appPacks.size(); i++) {
                    Pack appPack = appPacks.getPack(i);
                    appList.add(ApplicationDetails.fromPack(appPack));
                }

                message.setApplicationList(appList);
            }
            return message;
        }

        /***
         * generate {@link SyncApplicationsUpstreamMessage} instance
         *
         * @param context
         * @param applications
         * @return {@link SyncApplicationsUpstreamMessage} instance
         */
        public SyncApplicationsUpstreamMessage buildMessage(Context context, List<ApplicationDetails> applications) {
            SyncApplicationsUpstreamMessage message = new SyncApplicationsUpstreamMessage();
            populateMessage(message);

            message.setApplicationList(applications);

            return message;
        }
    }
}
