package com.pushpole.sdk.message.upstream;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-07-04, 1:05 PM.
 *
 * @author Akram Shokri
 */
public class RefactoredUpstreamMessage extends UpstreamMessage{

    @Override
    public Type getMessageType() {
        return Type.REFACTORED_UPSTREAM;
    }


    public static class Factory extends UpstreamMessageFactory {

        @Override
        public UpstreamMessage buildMessage(Pack pack) {
            RefactoredUpstreamMessage message = new RefactoredUpstreamMessage();
            populateMessage(message);

            return message;
        }

        public Pack addMessageIdToPack(Pack pack){
            UpstreamMessage msg = new RefactoredUpstreamMessage();
            populateMessage(msg);
            pack.put(Constants.getVal(Constants.F_MESSAGE_ID), msg.getMessageId());
            return pack;
        }
    }
}
