package com.pushpole.sdk.log;

class LogcatLogHandler implements LogHandler {
    private String logTag;
    private LogLevel level;
    private Boolean includeLogData;

    public LogcatLogHandler(String logTag, LogLevel level) {
        this.logTag = logTag;
        this.level = level;
        this.includeLogData = false;
    }

    public void onLog(LogItem logItem) {
        if (level == null || (logItem.logCatLevel != null && level.ordinal() > logItem.logCatLevel.ordinal())) {
            return;
        }

        String message = logItem.message;
        Throwable t = logItem.throwable;
        LogLevel realLevel = logItem.logCatLevel == null ? logItem.level : logItem.logCatLevel;
        if (includeLogData) {
            message += "  ${logItem.logData}";
        }

        if (t == null) {
            switch (realLevel) {
                case TRACE:
                    android.util.Log.v(logTag, message);
                    break;
                case DEBUG:
                    android.util.Log.d(logTag, message);
                    break;
                case INFO:
                    android.util.Log.i(logTag, message);
                    break;
                case WARN:
                    android.util.Log.w(logTag, message);
                    break;
                case ERROR:
                    android.util.Log.e(logTag, message);
                    break;
                case WTF:
                    android.util.Log.wtf(logTag, message);
                    break;
            }
        } else {
            switch (realLevel) {
                case TRACE:
                    android.util.Log.v(logTag, message, t);
                    break;
                case DEBUG:
                    android.util.Log.d(logTag, message, t);
                    break;
                case INFO:
                    android.util.Log.i(logTag, message, t);
                    break;
                case WARN:
                    android.util.Log.w(logTag, message, t);
                    break;
                case ERROR:
                    android.util.Log.e(logTag, message, t);
                    break;
                case WTF:
                    if (message == null) {
                        android.util.Log.wtf(logTag, t);
                    } else {
                        android.util.Log.wtf(logTag, message, t);
                    }
            }
        }
    }
}
