package com.pushpole.sdk.internal.log.handlers;

import android.content.Context;

import java.util.ArrayList;
import java.util.List;

import com.pushpole.sdk.internal.log.Log;
import com.pushpole.sdk.internal.log.LogHandler;

/**
 * A log handler that keeps logs in a list in memory
 * This class is registered to Logger.register using log_handlers.json file
 * This class is loaded by reflection and its constructor is called at runtime.
 * Do not mistaken by considering it an unused class.
 */
public class MemoryLogHandler implements LogHandler {
    private List<Log> mLogMessages;

    public MemoryLogHandler(Context context) {
        mLogMessages = new ArrayList<>();
    }

    @Override
    public void onLog(Log log) {
        mLogMessages.add(log);
    }

    public List<Log> getLogMessages() {
        return mLogMessages;
    }

}
