package com.pushpole.sdk.internal.log;

import java.util.MissingFormatArgumentException;

public class Log {
    private LogData mLogData;
    private LogLevel mLogLevel;
    private String mCulprit;
    private String mMessage;
    private Object[] mParams;
    private Throwable mException;
    private long mTimestamp;
    private boolean mPushPoleError;

    public LogLevel getLogLevel() {
        if (mLogLevel == null) {
            mLogLevel = LogLevel.INFO;
        }
        return mLogLevel;
    }

    public Log setLogLevel(LogLevel level) {
        mLogLevel = level;
        return this;
    }

    /**
     * Doesn't return null
     *
     * @return
     */
    public LogData getLogData() {
        if (mLogData == null) {
            mLogData = new LogData();
        }
        return mLogData;
    }

    public Log setLogData(LogData logData) {
        mLogData = logData;
        return this;
    }

    public String getCulprit() {
        if (mCulprit == null) {
            String level = getLogLevel().toString().toLowerCase();
            mCulprit = String.format("[%c%s] %s", Character.toUpperCase(level.charAt(0)),
                    level.substring(1), getFormatedMessage());
        }
        return mCulprit;
    }

    public Log setCulprit(String culprit) {
        mCulprit = culprit;
        return this;
    }

    public String getMessage() {
        if (mMessage == null) {
            mMessage = "";
        }
        return mMessage;
    }

    public Log setMessage(String message) {
        mMessage = message;
        return this;
    }

    public Object[] getParams() {
        if (mParams == null) {
            mParams = new Object[0];
        }
        return mParams;
    }

    public Log setParams(Object[] params) {
        mParams = params;
        return this;
    }

    public String getFormatedMessage() {
        try {
            return String.format(getMessage(), getParams());
        } catch (MissingFormatArgumentException e) {
            return getMessage();
        }
    }

    public long getTimestamp() {
        return mTimestamp;
    }

    public Log setTimestamp(long timestamp) {
        mTimestamp = timestamp;
        return this;
    }

    public Throwable getException() {
        return mException;
    }

    public Log setException(Throwable exception) {
        mException = exception;
        return this;
    }

    public Log addLogData(String key, String value) {
        getLogData().put(key, value);
        return this;
    }

    public Log setStackTrace() {
        mException = new DummyLogException();
        return this;
    }

    public boolean isPushPoleError() {
        return mPushPoleError;
    }

    public void setPushPoleError(boolean pushpoleError) {
        mPushPoleError = pushpoleError;
    }
}
