package com.pushpole.sdk.internal.db;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;

import java.util.Date;

import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.util.Utility;

/**
 * Created on 16-03-29, 4:20 PM.
 *
 * @author Akram Shokri
 */
public class TaskDbOperation {

    // Database fields
    private SQLiteDatabase database;
    private DatabaseHelper dbHelper;

    public TaskDbOperation(Context context) {
        dbHelper = DatabaseHelper.getInstance(context);
    }

    public void open() throws SQLException {
        if (database == null || (database != null && !database.isOpen()))
            database = dbHelper.getWritableDatabase();
    }

    public void close() {
        dbHelper.close();
    }

    public boolean isTaskExists(long taskDbId) {
        String selectQuery = "SELECT * FROM " + DatabaseHelper.TABLE_TASK + " t WHERE t."
                + DatabaseHelper.COLUMN_ID + " = " + taskDbId;
        Cursor cursor = database.rawQuery(selectQuery, null);

        boolean res = cursor.moveToFirst();
        cursor.close();
        return res;
    }

    public int removeTask(long taskDbId) {
        String whereClause = DatabaseHelper.COLUMN_ID + " = ? ";

        String[] whereArgs = new String[]{
                String.valueOf(taskDbId)
        };

        int affectedRows = database.delete(DatabaseHelper.TABLE_TASK, whereClause, whereArgs);

        if (affectedRows != 1) {
            Logger.debug("Removing single task from android sqlite DB affected 0 row or more than 1 rows");
        }
        return affectedRows;
    }

    private String getDateTime() {
        return Utility.getFormattedDate(new Date(), "yyyy-MM-dd kk:mm:ss"); //kk is 24-hour time format in DateFormat
    }

}

