package com.pushpole.sdk.device;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;

/**
 * Helper class for extracting device related information
 */
public class DeviceInfoHelper {
    private Context mContext;

    /**
     * Constructs a {@code DeviceInfoHelper}
     *
     * @param context the context to use
     */
    public DeviceInfoHelper(Context context) {
        mContext = context;
    }

    /**
     * @return The platform of the device running the app
     */
    public DevicePlatform getDevicePlatform() {
        return DevicePlatform.ANDROID;
    }

    /**
     * @return The media type (e.g. phone, tablet, browser) of the device
     */
    public DeviceMedia getDeviceMedia() {
        boolean isTablet = (mContext.getResources().getConfiguration().screenLayout
                & Configuration.SCREENLAYOUT_SIZE_MASK)
                >= Configuration.SCREENLAYOUT_SIZE_LARGE;
        if (isTablet) {
            return DeviceMedia.TABLET;
        } else {
            return DeviceMedia.PHONE;
        }
    }

    /**
     * @return The device model name (e.g. Galaxy S2)
     */
    public String getDeviceModel() {
        return Build.MODEL;
    }

    /**
     * @return The device brand name (e.g. Samsung)
     */
    public String getDeviceBrand() {
        return Build.MANUFACTURER;
    }


    /**
     * @return The device OS version (e.g. 4.4.2)
     */
    public String getOSVersion() {
        return Build.VERSION.RELEASE;
    }

    /**
     * @return The device screen size
     */

    public Point getScreenSize() {
        Point point = new Point();
        DisplayMetrics display = mContext.getResources().getDisplayMetrics();
        point.set(display.widthPixels, display.heightPixels);
        return point;
    }
}
