package com.pushpole.sdk.controller.factory;

import android.content.Context;

import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.controller.DownstreamApiFactory;
import com.pushpole.sdk.controller.controllers.SubscriptionController;

/**
 * Factory class to generate {@link SubscriptionController} instance
 */
public class SubscriptionApiFactory implements DownstreamApiFactory {
    /***
     * generate {@link SubscriptionController} instance
     *
     * @param context
     * @return
     */
    @Override
    public DownstreamApiController buildDownstreamHandler(Context context) {
        return new SubscriptionController(context);
    }
}
