package com.pushpole.sdk.controller.controllers;

import android.content.Context;
import android.graphics.Point;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.Constants.Info;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.device.DeviceIDHelper;
import com.pushpole.sdk.device.DeviceInfoHelper;
import com.pushpole.sdk.device.TelephonyInfo;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.message.upstream.UpstreamMessageFactory;
import com.pushpole.sdk.network.UpstreamSender;
import com.pushpole.sdk.task.PushPoleAsyncTask;
import com.pushpole.sdk.task.TaskManager;
import com.pushpole.sdk.util.Crypto;
import com.pushpole.sdk.util.ListPack;
import com.pushpole.sdk.util.Pack;
import com.pushpole.sdk.util.PermissionChecker;


/**
 * Created on 16-07-05, 10:57 AM.
 *
 * @author Akram Shokri
 */
public class ConstantDeviceDataController implements DownstreamApiController {

    private Context mContext;

    public ConstantDeviceDataController(Context mContext) {
        this.mContext = mContext;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        Logger.info("Downstream message constant data");
        sendConstantData();
    }

    private void sendConstantData(){
        ListPack listPack = new ListPack();
        listPack.addPack(getConstantData());

        final Pack upstreamPack = new Pack();
        upstreamPack.putListPack(Constants.getVal(Constants.CONSTANT_DATA_T), listPack);
        upstreamPack.putString(Constants.getVal(Constants.F_MESSAGE_ID), UpstreamMessageFactory.generateMsgId());
        //TODO: @ak, maybe needs sending corresponding upstream msg immediately, without TaskScheduler
        TaskManager.getInstance(mContext).asyncTask(new PushPoleAsyncTask() {
            @Override
            public void run(Context context) {
                new UpstreamSender(context).sendMessage(upstreamPack);
            }
        });
    }

    public Pack getConstantData(){
        DeviceInfoHelper deviceInfoHelper = new DeviceInfoHelper(mContext);
        Pack devicePack = new Pack();
        devicePack.putString(Constants.getVal(Info.F_DEVICE_BRAND), deviceInfoHelper.getDeviceBrand());
        devicePack.putString(Constants.getVal(Info.F_DEVICE_MODEL), deviceInfoHelper.getDeviceModel());

        Point screenSize = deviceInfoHelper.getScreenSize();
        String mScreenSize = String.format("%dx%d", screenSize.x, screenSize.y);
        devicePack.putString(Constants.getVal(Info.F_SCREEN_SIZE), mScreenSize);

        DeviceIDHelper idHelper = new DeviceIDHelper(mContext);
        devicePack.putString(Constants.getVal(Info.F_DEVICE_ID), idHelper.getDeviceId());

        String mainSimImei = idHelper.getIMEI();
        if(mainSimImei != null && !mainSimImei.isEmpty())
            devicePack.putString(Constants.getVal(Info.F_PERMITED_IMEI), mainSimImei);

        String secondSimImei = idHelper.getSecondSimIMEI();
        if(secondSimImei != null && !secondSimImei.isEmpty() && !secondSimImei.equals(mainSimImei))
            devicePack.putString(Constants.getVal(Info.F_PERMITED_IMEI_2), secondSimImei);

        /*SubscriptionManager sm = null;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP_MR1) {
            sm = SubscriptionManager.from(mContext);
            sm.getActiveSubscriptionInfoList();
        }*/
        devicePack.putString(Constants.getVal(Constants.TIMESTAMP), String.valueOf(System.currentTimeMillis()));

        return devicePack;
    }




}
