package com.pushpole.sdk.collection.tasks;

import android.content.Context;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.controller.controllers.MobileCellInfoController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.task.Result;
import com.pushpole.sdk.task.options.DefaultOptions;
import com.pushpole.sdk.task.options.SingletonTask;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-12-12, 6:12 PM.
 *
 * @author Akram Shokri
 */

@SingletonTask
@DefaultOptions(period = 6 * 60 * 60 * 1000) //default schedule: 6 hours
public class MobileCellTask extends CollectionTask{
    @Override
    public Result runTask(Context context, Pack taskData) {
        Logger.info("Running mobile cell task");
        if (taskData == null || !taskData.getBool("force")) {
            Long collectionPeriod = KeyStore.getInstance(context).getLong("collection_period_t6", 6 * 60 * 60 * 1000L);
            Long lastCollectionTime = KeyStore.getInstance(context).getLong("last_collection_t6", 0);

            if (collectionPeriod == -1) {
                Logger.warning("Skipping cell data collection, the collection has been cancelled and should not run");
                return Result.SUCCESS;
            } else {
                Long now = System.currentTimeMillis();
                if (lastCollectionTime > 0 && now > lastCollectionTime && (now - lastCollectionTime) < collectionPeriod) {
                    Logger.warning("Skipping cell data collection since it has already been run in this interval", new LogData(
                            "Last Run", String.valueOf(lastCollectionTime),
                            "Now", String.valueOf(now),
                            "Period", String.valueOf(collectionPeriod)
                    ));
                    return Result.SUCCESS;
                }
                KeyStore.getInstance(context).putLong("last_collection_t6", now);
            }
        }


        this.processResult(context, new MobileCellInfoController(context).getCellInfo(),
                Constants.getVal(Constants.CELL_INFO_T));
        return Result.SUCCESS;
    }

}
