package com.pushpole.sdk.collection;

import android.content.Context;

import java.util.HashMap;
import java.util.Map;

import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.task.PushPoleAsyncTask;
import com.pushpole.sdk.task.PushPoleTask;
import com.pushpole.sdk.task.TaskManager;
import com.pushpole.sdk.task.options.TaskOptions;
import com.pushpole.sdk.util.Pack;

public class CollectionManager {
    private static CollectionManager mInstance;

    public CollectionManager() {
    }

    public static CollectionManager getInstance() {
        if (mInstance == null) {
            synchronized (CollectionManager.class) {
                if (mInstance == null) {
                    mInstance = new CollectionManager();
                }
            }
        }
        return mInstance;
    }

    public void cancelCollection(Context context, CollectionType collectionType) {
        TaskManager.getInstance(context).cancelTask(collectionType.getCollectionTask());
    }

    public void collectNow(final Context context, final CollectionType collectionType, long delay) {
        // TODO Implement CollectionManager.collectNow
        TaskManager.getInstance(context).asyncTask(new PushPoleAsyncTask() {
            @Override
            public void run(Context context) {
                try {
                    PushPoleTask task = (PushPoleTask)collectionType.getCollectionTask().newInstance();
                    Map<String, Object> data = new HashMap<>();
                    data.put("force", true);
                    task.runTask(context, new Pack(data));
                } catch (InstantiationException e) {
                    Logger.warning("InstantiationException in collectNow()", e);
                } catch (IllegalAccessException e) {
                    Logger.warning("IllegalAccessException in collectNow()", e);
                }
            }
        });
    }

    public void collectNow(Context context, CollectionType collectionType) {
        collectNow(context, collectionType, 0);
    }

    public void setCollectionPeriod(Context context, CollectionType collectionType, long period) {
        TaskOptions options = new TaskOptions.Builder().setPeriod(period).build();
        TaskManager.getInstance(context).scheduleTask(collectionType.getCollectionTask(), options);
    }

    public void startCollection(Context context, CollectionType collectionType) {
        TaskOptions options = new TaskOptions.Builder().build();
        TaskManager.getInstance(context).scheduleTask(collectionType.getCollectionTask(), options);
    }

}
