package com.pushpole.sdk.action.actions;

import android.content.Context;
import android.content.Intent;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.action.Action;
import com.pushpole.sdk.action.ActionFactory;
import com.pushpole.sdk.action.ActionType;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-08-31, 10:12 AM.
 *
 * @author Akram Shokri
 */
public class UserActivityAction extends Action {
    private String activityClassName;
    private String pushpoleActivityExtra;

    @Override
    public void execute(Context context) {
        try{
            String packageName = context.getPackageName();
            Class<?> activityClass;
            if (activityClassName == null || activityClassName.isEmpty()) {
                throw new Exception("No activity name or package is received");
            }
            if (activityClassName.startsWith(".")) {
                activityClass = Class.forName(packageName + activityClassName);
            } else if (!activityClassName.contains(".")) {
                activityClass = Class.forName(packageName + "." + activityClassName);
            } else {
                try {
                    activityClass = Class.forName(activityClassName);
                } catch (ClassNotFoundException e) {
                    activityClass = Class.forName(packageName + "." + activityClassName);
                }
            }

            if (activityClass == null) {
                throw new Exception("Failed to create class of the input activity name" + activityClassName);
            }

            Intent intent = new Intent(context, activityClass);
            intent.putExtra(PlainConstants.KEY_STORE_USE_IMEI_USER_ANSWER, pushpoleActivityExtra);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        }catch (Exception e){
            Logger.warning("Failed to start user activity", new LogData("error", e.getMessage(), "activity name", activityClassName));
            android.util.Log.e("PushPole", "Failed to start activity", e);
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.USER_ACTIVITY;
    }

    @Override
    public Pack toPack() {
        Pack pack = super.toPack();
        pack.putString(Constants.getVal(Constants.F_USER_ACTIVITY_NAME), activityClassName);
        pack.putString(PlainConstants.KEY_STORE_USE_IMEI_USER_ANSWER, pushpoleActivityExtra);
        return pack;
    }

    public static class Factory extends ActionFactory {

        /**
         * generate {@link DialogAction} instance
         *
         * @param data the data to create the {@code Action} with given as a {@link Pack}
         * @return
         */
        @Override
        public Action buildAction(Pack data) {
            UserActivityAction action = new UserActivityAction();

            action.activityClassName = data.getString(Constants.getVal(Constants.F_USER_ACTIVITY_NAME), "");
            action.pushpoleActivityExtra = data.getString(PlainConstants.KEY_STORE_USE_IMEI_USER_ANSWER, "");

            return action;
        }
    }
}
