/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.crypto.nacl;

import com.pusher.client.crypto.nacl.Subtle;

public class Poly1305 {
    public static final int TAG_SIZE = 16;
    private static final double ALPHAM_80 = 5.587935447692871E-9;
    private static final double ALPHAM_48 = 24.0;
    private static final double ALPHAM_16 = 1.03079215104E11;
    private static final double ALPHA_0 = 6.755399441055744E15;
    private static final double ALPHA_18 = 1.770887431076117E21;
    private static final double ALPHA_32 = 2.90142196707511E25;
    private static final double ALPHA_50 = 7.605903601369376E30;
    private static final double ALPHA_64 = 1.2461512460483586E35;
    private static final double ALPHA_82 = 3.2667107224410092E40;
    private static final double ALPHA_96 = 5.3521788476473496E44;
    private static final double ALPHA_112 = 3.507603929594167E49;
    private static final double ALPHA_130 = 9.194973245195333E54;
    private static final double SCALE = (double)3.67342E-39f;
    private static final double OFFSET_0 = 6.755408030990331E15;
    private static final double OFFSET_1 = 2.901425656423924E25;
    private static final double OFFSET_2 = 1.2461528306116085E35;
    private static final double OFFSET_3 = 5.352192458942025E44;

    private static long uint32(long x) {
        return 0xFFFFFFFFFFFFFFFFL & x;
    }

    private static double longBitsToDouble(long bits) {
        int s = bits >> 63 == 0L ? 1 : -1;
        int e = (int)(bits >> 52 & 0x7FFL);
        long m = e == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        return (double)s * (double)m * Math.pow(2.0, e - 1075);
    }

    public static boolean verify(byte[] mac, byte[] m, byte[] key) {
        byte[] tmp = Poly1305.sum(m, key);
        return Subtle.constantTimeCompare(tmp, mac);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] sum(byte[] m, byte[] key) {
        void out;
        void sr3highx2;
        double sr3lowx2;
        void r2highx2;
        void r2lowx2;
        void r1highx2;
        void r1lowx2;
        void r0highx2;
        void r0lowx2;
        void sr2lowx4;
        void sr2highx4;
        double sr3lowx4;
        void sr3highx4;
        void r0lowx4;
        void r0highx4;
        void r1lowx4;
        void r1highx4;
        void sr3highx6;
        void r2highx0;
        double sr3lowx6;
        void r2lowx0;
        void sr3high_stack;
        void sr2highx6;
        void sr3low_stack;
        void r1highx0;
        void r2high_stack;
        void sr2lowx6;
        void r2low_stack;
        void r1lowx0;
        void sr2high_stack;
        void sr1highx6;
        void sr2low_stack;
        void r0highx0;
        void r1high_stack;
        void sr1lowx6;
        void r1low_stack;
        void r0lowx0;
        void sr1high_stack;
        void r0highx6;
        void x2;
        void sr1low_stack;
        void r3highx0;
        void x3;
        void r0high_stack;
        void r0lowx6;
        void x4;
        void r3high_stack;
        void r3lowx0;
        void x5;
        void r0low_stack;
        void r3low_stack;
        void y2;
        void h2;
        void y3;
        void h3;
        void x0;
        void x1;
        void x6;
        void x7;
        void y4;
        void h4;
        void y5;
        void h5;
        void y0;
        void h0;
        void y1;
        void h1;
        void y6;
        void h6;
        void y7;
        void h7;
        double z3;
        double z2;
        double z1;
        double z0;
        long m33;
        long m32;
        long m31;
        long m30;
        long m23;
        long m22;
        long m21;
        long m20;
        long m13;
        long m12;
        long m11;
        long m10;
        long m03;
        long m3;
        long m02;
        long m2;
        long m01;
        long m1;
        long m0;
        long m00;
        void sr3high;
        void r3high;
        void sr2high;
        void r2high;
        void sr1high;
        void r0low;
        void r3low;
        void r1high;
        void sr2low;
        void r0high;
        void sr1low;
        void r2low;
        void r1low;
        long d3;
        long d2;
        long d1;
        long d0;
        void r30;
        void r20;
        byte[] r = (byte[])key.clone();
        byte[] s = new byte[16];
        System.arraycopy(key, 16, s, 0, s.length);
        long p = 0L;
        int l = m.length;
        long r00 = 0xFF & r[0];
        long r01 = 0xFF & r[1];
        long r02 = 0xFF & r[2];
        long r0 = 2151L;
        long r03 = 0xFF & r[3];
        r03 &= 0xFL;
        r0 <<= 51;
        long r10 = 0xFF & r[4];
        r10 &= 0xFCL;
        r0 += r00;
        long r11 = 0xFF & r[5];
        r0 += (r01 <<= 8);
        long r12 = 0xFF & r[6];
        r0 += (r02 <<= 16);
        long r13 = 0xFF & r[7];
        r13 &= 0xFL;
        long l2 = 2215L;
        long l3 = r0 += (r03 <<= 24);
        r1 <<= 51;
        long l4 = 2279L;
        long l5 = 0xFF & r[8];
        r20 &= 0xFCL;
        r1 += r10;
        long l6 = 0xFF & r[9];
        r1 += (r11 <<= 8);
        long l7 = 0xFF & r[10];
        r1 += (r12 <<= 16);
        long l8 = 0xFF & r[11];
        r23 &= 0xFL;
        r2 <<= 51;
        void var271_22 = r1 += (r13 <<= 24);
        r2 += r20;
        long l9 = 0xFF & r[12];
        r30 &= 0xFCL;
        r2 += (r21 <<= 8);
        long l10 = 0xFF & r[13];
        r2 += (r22 <<= 16);
        long l11 = 0xFF & r[14];
        long l12 = 2343L;
        void var281_27 = r2 += (r23 <<= 24);
        r3 <<= 51;
        long l13 = 0xFF & r[15];
        r33 &= 0xFL;
        r3 += r30;
        r3 += (r31 <<= 8);
        r3 += (r32 <<= 16);
        double d = 0.0;
        void var287_30 = r3 += (r33 <<= 24);
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = Double.longBitsToDouble(d0);
        double d9 = 0.0;
        double d10 = Poly1305.longBitsToDouble(d1);
        double d11 = 0.0;
        double d12 = Double.longBitsToDouble(d2);
        double d13 = 0.0;
        void var309_41 = (r0low -= 6.755399441055744E15) + 1.770887431076117E21;
        double d14 = Double.longBitsToDouble(d3);
        void var313_43 = (r1low -= 2.90142196707511E25) + 7.605903601369376E30;
        double d15 = (double)3.67342E-39f * r1low;
        void var317_45 = (r2low -= 1.2461512460483586E35) + 3.2667107224410092E40;
        double d16 = (double)3.67342E-39f * r2low;
        void var321_47 = r0high -= 1.770887431076117E21;
        void var323_48 = r1high -= 7.605903601369376E30;
        void var325_49 = sr1low + 5.587935447692871E-9;
        r0low -= r0high;
        double sr3low = (double)3.67342E-39f * (r3low -= 5.3521788476473496E44);
        void var327_51 = sr2low + 24.0;
        void var329_52 = r1low -= r1high;
        void var331_53 = sr1high -= 5.587935447692871E-9;
        void var333_54 = r2low -= (r2high -= 3.2667107224410092E40);
        void var335_55 = sr2high -= 24.0;
        void var337_56 = r3low + 3.507603929594167E49;
        void var339_57 = r0low;
        void var341_58 = sr1low -= sr1high;
        double d17 = sr3low + 1.03079215104E11;
        void var345_60 = r2high;
        void var347_61 = sr2low -= sr2high;
        void var349_62 = r3high -= 3.507603929594167E49;
        void var351_63 = sr3high -= 1.03079215104E11;
        void var353_64 = r3low -= r3high;
        double d18 = sr3low -= sr3high;
        if (l >= 16) {
            m00 = 0xFF & m[(int)p];
            m0 = 2151L;
            m0 <<= 51;
            m1 = 2215L;
            m01 = 0xFF & m[(int)p + 1];
            m1 <<= 51;
            m2 = 2279L;
            m02 = 0xFF & m[(int)p + 2];
            m2 <<= 51;
            m3 = 2343L;
            m03 = 0xFF & m[(int)p + 3];
            m10 = 0xFF & m[(int)p + 4];
            m0 += m00;
            m11 = 0xFF & m[(int)p + 5];
            m0 += (m01 <<= 8);
            m12 = 0xFF & m[(int)p + 6];
            m0 += (m02 <<= 16);
            m13 = 0xFF & m[(int)p + 7];
            m3 <<= 51;
            m0 += (m03 <<= 24);
            m20 = 0xFF & m[(int)p + 8];
            m1 += m10;
            m21 = 0xFF & m[(int)p + 9];
            m1 += (m11 <<= 8);
            m22 = 0xFF & m[(int)p + 10];
            m1 += (m12 <<= 16);
            m23 = 0xFF & m[(int)p + 11];
            m1 += (m13 <<= 24);
            m30 = 0xFF & m[(int)p + 12];
            m2 += m20;
            m31 = 0xFF & m[(int)p + 13];
            m2 += (m21 <<= 8);
            m32 = 0xFF & m[(int)p + 14];
            m2 += (m22 <<= 16);
            m33 = 0xFF & m[(int)p + 15];
            d0 = m0;
            m3 += m30;
            d1 = m1;
            m3 += (m31 <<= 8);
            d2 = m2 += (m23 <<= 24);
            m33 += 256L;
            m3 += (m32 <<= 16);
            d3 = m3 += (m33 <<= 24);
            p += 16L;
            l -= 16;
            z0 = Double.longBitsToDouble(d0);
            z1 = Double.longBitsToDouble(d1);
            z2 = Double.longBitsToDouble(d2);
            z3 = Double.longBitsToDouble(d3);
            h0 += (z0 -= 6.755399441055744E15);
            h1 += (z1 -= 2.90142196707511E25);
            h3 += (z2 -= 1.2461512460483586E35);
            h5 += (z3 -= 5.3521788476473496E44);
            while (l >= 16) {
                m2 = 2279L;
                m20 = 0xFF & m[(int)p + 8];
                y7 = h7 + 9.194973245195333E54;
                m2 <<= 51;
                m3 = 2343L;
                m21 = 0xFF & m[(int)p + 9];
                y6 = h6 + 9.194973245195333E54;
                m3 <<= 51;
                m0 = 2151L;
                m22 = 0xFF & m[(int)p + 10];
                y1 = h1 + 2.90142196707511E25;
                m0 <<= 51;
                m1 = 2215L;
                m23 = 0xFF & m[(int)p + 11];
                y0 = h0 + 2.90142196707511E25;
                m1 <<= 51;
                m30 = 0xFF & m[(int)p + 12];
                y7 -= 9.194973245195333E54;
                m2 += m20;
                m31 = 0xFF & m[(int)p + 13];
                y6 -= 9.194973245195333E54;
                m2 += (m21 <<= 8);
                m32 = 0xFF & m[(int)p + 14];
                y1 -= 2.90142196707511E25;
                m2 += (m22 <<= 16);
                m33 = 0xFF & m[(int)p + 15];
                y0 -= 2.90142196707511E25;
                m2 += (m23 <<= 24);
                m00 = 0xFF & m[(int)p];
                y5 = h5 + 5.3521788476473496E44;
                m31 <<= 8;
                m3 += m30;
                m01 = 0xFF & m[(int)p + 1];
                y4 = h4 + 5.3521788476473496E44;
                m32 <<= 16;
                m02 = 0xFF & m[(int)p + 2];
                x7 = h7 - y7;
                y7 *= (double)3.67342E-39f;
                m33 += 256L;
                m03 = 0xFF & m[(int)p + 3];
                x6 = h6 - y6;
                y6 *= (double)3.67342E-39f;
                m33 <<= 24;
                m3 += m31;
                m10 = 0xFF & m[(int)p + 4];
                x1 = h1 - y1;
                m01 <<= 8;
                m3 += m32;
                m11 = 0xFF & m[(int)p + 5];
                x0 = h0 - y0;
                m3 += m33;
                m0 += m00;
                m12 = 0xFF & m[(int)p + 6];
                y5 -= 5.3521788476473496E44;
                m0 += m01;
                m13 = 0xFF & m[(int)p + 7];
                y4 -= 5.3521788476473496E44;
                m0 += (m02 <<= 16);
                d2 = m2;
                x1 += y7;
                d3 = m3;
                x0 += y6;
                m1 += m10;
                d0 = m0 += (m03 <<= 24);
                x7 += y5;
                m1 += (m11 <<= 8);
                x6 += y4;
                m1 += (m12 <<= 16);
                y3 = h3 + 1.2461512460483586E35;
                d1 = m1 += (m13 <<= 24);
                y2 = h2 + 1.2461512460483586E35;
                x0 += x1;
                x6 += x7;
                y3 -= 1.2461512460483586E35;
                r3low = r3low_stack;
                y2 -= 1.2461512460483586E35;
                r0low = r0low_stack;
                x5 = h5 - y5;
                r3lowx0 = r3low * x0;
                r3high = r3high_stack;
                x4 = h4 - y4;
                r0lowx6 = r0low * x6;
                r0high = r0high_stack;
                x3 = h3 - y3;
                r3highx0 = r3high * x0;
                sr1low = sr1low_stack;
                x2 = h2 - y2;
                r0highx6 = r0high * x6;
                sr1high = sr1high_stack;
                x5 += y3;
                r0lowx0 = r0low * x0;
                r1low = r1low_stack;
                h6 = r3lowx0 + r0lowx6;
                sr1lowx6 = sr1low * x6;
                r1high = r1high_stack;
                x4 += y2;
                r0highx0 = r0high * x0;
                sr2low = sr2low_stack;
                h7 = r3highx0 + r0highx6;
                sr1highx6 = sr1high * x6;
                sr2high = sr2high_stack;
                x3 += y1;
                r1lowx0 = r1low * x0;
                r2low = r2low_stack;
                h0 = r0lowx0 + sr1lowx6;
                sr2lowx6 = sr2low * x6;
                r2high = r2high_stack;
                x2 += y0;
                r1highx0 = r1high * x0;
                sr3low = sr3low_stack;
                h1 = r0highx0 + sr1highx6;
                sr2highx6 = sr2high * x6;
                sr3high = sr3high_stack;
                x4 += x5;
                r2lowx0 = r2low * x0;
                z2 = Double.longBitsToDouble(d2);
                h2 = r1lowx0 + sr2lowx6;
                sr3lowx6 = sr3low * x6;
                x2 += x3;
                r2highx0 = r2high * x0;
                z3 = Double.longBitsToDouble(d3);
                h3 = r1highx0 + sr2highx6;
                sr3highx6 = sr3high * x6;
                r1highx4 = r1high * x4;
                z2 -= 1.2461512460483586E35;
                h4 = r2lowx0 + sr3lowx6;
                r1lowx4 = r1low * x4;
                r0highx4 = r0high * x4;
                z3 -= 5.3521788476473496E44;
                h5 = r2highx0 + sr3highx6;
                r0lowx4 = r0low * x4;
                h7 += r1highx4;
                sr3highx4 = sr3high * x4;
                h6 += r1lowx4;
                sr3lowx4 = sr3low * x4;
                h5 += r0highx4;
                sr2highx4 = sr2high * x4;
                h4 += r0lowx4;
                sr2lowx4 = sr2low * x4;
                h3 += sr3highx4;
                r0lowx2 = r0low * x2;
                h2 += sr3lowx4;
                r0highx2 = r0high * x2;
                h1 += sr2highx4;
                r1lowx2 = r1low * x2;
                h0 += sr2lowx4;
                r1highx2 = r1high * x2;
                h2 += r0lowx2;
                r2lowx2 = r2low * x2;
                h3 += r0highx2;
                r2highx2 = r2high * x2;
                h4 += r1lowx2;
                sr3lowx2 = sr3low * x2;
                h5 += r1highx2;
                sr3highx2 = sr3high * x2;
                p += 16L;
                l -= 16;
                h6 += r2lowx2;
                h7 += r2highx2;
                z1 = Double.longBitsToDouble(d1);
                h0 += sr3lowx2;
                z0 = Double.longBitsToDouble(d0);
                h1 += sr3highx2;
                h5 += z3;
                h3 += z2;
                h1 += (z1 -= 2.90142196707511E25);
                h0 += (z0 -= 6.755399441055744E15);
            }
            y7 = h7 + 9.194973245195333E54;
            y6 = h6 + 9.194973245195333E54;
            y1 = h1 + 2.90142196707511E25;
            y0 = h0 + 2.90142196707511E25;
            y7 -= 9.194973245195333E54;
            y6 -= 9.194973245195333E54;
            y1 -= 2.90142196707511E25;
            y0 -= 2.90142196707511E25;
            y5 = h5 + 5.3521788476473496E44;
            y4 = h4 + 5.3521788476473496E44;
            x7 = h7 - y7;
            x6 = h6 - y6;
            x1 = h1 - y1;
            x0 = h0 - y0;
            x0 += (y6 *= (double)3.67342E-39f);
            x6 += (y4 -= 5.3521788476473496E44);
            y3 = h3 + 1.2461512460483586E35;
            y2 = h2 + 1.2461512460483586E35;
            x0 += (x1 += (y7 *= (double)3.67342E-39f));
            x6 += (x7 += (y5 -= 5.3521788476473496E44));
            y3 -= 1.2461512460483586E35;
            r3low = r3low_stack;
            y2 -= 1.2461512460483586E35;
            r0low = r0low_stack;
            x5 = h5 - y5;
            r3lowx0 = r3low * x0;
            r3high = r3high_stack;
            x4 = h4 - y4;
            r0lowx6 = r0low * x6;
            r0high = r0high_stack;
            x3 = h3 - y3;
            r3highx0 = r3high * x0;
            sr1low = sr1low_stack;
            x2 = h2 - y2;
            r0highx6 = r0high * x6;
            sr1high = sr1high_stack;
            x5 += y3;
            r0lowx0 = r0low * x0;
            r1low = r1low_stack;
            h6 = r3lowx0 + r0lowx6;
            sr1lowx6 = sr1low * x6;
            r1high = r1high_stack;
            x4 += y2;
            r0highx0 = r0high * x0;
            sr2low = sr2low_stack;
            h7 = r3highx0 + r0highx6;
            sr1highx6 = sr1high * x6;
            sr2high = sr2high_stack;
            x3 += y1;
            r1lowx0 = r1low * x0;
            r2low = r2low_stack;
            h0 = r0lowx0 + sr1lowx6;
            sr2lowx6 = sr2low * x6;
            r2high = r2high_stack;
            x2 += y0;
            r1highx0 = r1high * x0;
            sr3low = sr3low_stack;
            h1 = r0highx0 + sr1highx6;
            sr2highx6 = sr2high * x6;
            sr3high = sr3high_stack;
            x4 += x5;
            r2lowx0 = r2low * x0;
            h2 = r1lowx0 + sr2lowx6;
            sr3lowx6 = sr3low * x6;
            x2 += x3;
            r2highx0 = r2high * x0;
            h3 = r1highx0 + sr2highx6;
            sr3highx6 = sr3high * x6;
            r1highx4 = r1high * x4;
            h4 = r2lowx0 + sr3lowx6;
            r1lowx4 = r1low * x4;
            r0highx4 = r0high * x4;
            h5 = r2highx0 + sr3highx6;
            r0lowx4 = r0low * x4;
            h7 += r1highx4;
            sr3highx4 = sr3high * x4;
            h6 += r1lowx4;
            sr3lowx4 = sr3low * x4;
            h5 += r0highx4;
            sr2highx4 = sr2high * x4;
            h4 += r0lowx4;
            sr2lowx4 = sr2low * x4;
            h3 += sr3highx4;
            r0lowx2 = r0low * x2;
            h2 += sr3lowx4;
            r0highx2 = r0high * x2;
            h1 += sr2highx4;
            r1lowx2 = r1low * x2;
            h0 += sr2lowx4;
            r1highx2 = r1high * x2;
            h2 += r0lowx2;
            r2lowx2 = r2low * x2;
            h3 += r0highx2;
            r2highx2 = r2high * x2;
            h4 += r1lowx2;
            sr3lowx2 = sr3low * x2;
            h5 += r1highx2;
            sr3highx2 = sr3high * x2;
            h6 += r2lowx2;
            h7 += r2highx2;
            h0 += sr3lowx2;
            h1 += sr3highx2;
        }
        if (l > 0) {
            long lbelow2 = l - 2;
            long lbelow3 = l - 3;
            long lbelow4 = l - 4;
            m00 = 0xFF & m[(int)p];
            m01 = 0xFF & m[(int)(p += (lbelow2 >>= 31)) + 1];
            m02 = 0xFF & m[(int)(p += (lbelow3 >>= 31)) + 2];
            m0 = 2151L;
            m03 = 0xFF & m[(int)(p += (lbelow4 >>= 31)) + 3];
            m0 <<= 51;
            m1 = 2215L;
            m0 += m00;
            m01 &= Poly1305.uint32(lbelow2) ^ 0xFFFFFFFFFFFFFFFFL;
            m02 &= Poly1305.uint32(lbelow3) ^ 0xFFFFFFFFFFFFFFFFL;
            m01 -= Poly1305.uint32(lbelow2);
            m03 &= Poly1305.uint32(lbelow4) ^ 0xFFFFFFFFFFFFFFFFL;
            m0 += (m01 <<= 8);
            m02 += Poly1305.uint32(lbelow2 -= lbelow3);
            m03 += Poly1305.uint32(lbelow3 -= lbelow4);
            m0 += (m02 <<= 16);
            m0 += (m03 <<= 24);
            long lbelow5 = l - 5;
            long lbelow6 = l - 6;
            long lbelow7 = l - 7;
            long lbelow8 = l - 8;
            m10 = 0xFF & m[(int)(p += (lbelow5 >>= 31)) + 4];
            m11 = 0xFF & m[(int)(p += (lbelow6 >>= 31)) + 5];
            m12 = 0xFF & m[(int)(p += (lbelow7 >>= 31)) + 6];
            m1 <<= 51;
            m13 = 0xFF & m[(int)(p += (lbelow8 >>= 31)) + 7];
            m10 &= Poly1305.uint32(lbelow5) ^ 0xFFFFFFFFFFFFFFFFL;
            m10 += Poly1305.uint32(lbelow4 -= lbelow5);
            m11 &= Poly1305.uint32(lbelow6) ^ 0xFFFFFFFFFFFFFFFFL;
            m11 += Poly1305.uint32(lbelow5 -= lbelow6);
            m1 += m10;
            m1 += (m11 <<= 8);
            m12 &= Poly1305.uint32(lbelow7) ^ 0xFFFFFFFFFFFFFFFFL;
            m13 &= Poly1305.uint32(lbelow8) ^ 0xFFFFFFFFFFFFFFFFL;
            m12 += Poly1305.uint32(lbelow6 -= lbelow7);
            m13 += Poly1305.uint32(lbelow7 -= lbelow8);
            m1 += (m12 <<= 16);
            m1 += (m13 <<= 24);
            m2 = 2279L;
            long lbelow9 = l - 9;
            m3 = 2343L;
            long lbelow10 = l - 10;
            long lbelow11 = l - 11;
            long lbelow12 = l - 12;
            m20 = 0xFF & m[(int)(p += (lbelow9 >>= 31)) + 8];
            m21 = 0xFF & m[(int)(p += (lbelow10 >>= 31)) + 9];
            m22 = 0xFF & m[(int)(p += (lbelow11 >>= 31)) + 10];
            m2 <<= 51;
            m23 = 0xFF & m[(int)(p += (lbelow12 >>= 31)) + 11];
            m20 &= Poly1305.uint32(lbelow9) ^ 0xFFFFFFFFFFFFFFFFL;
            m20 += Poly1305.uint32(lbelow8 -= lbelow9);
            m21 &= Poly1305.uint32(lbelow10) ^ 0xFFFFFFFFFFFFFFFFL;
            m21 += Poly1305.uint32(lbelow9 -= lbelow10);
            m2 += m20;
            m2 += (m21 <<= 8);
            m22 &= Poly1305.uint32(lbelow11) ^ 0xFFFFFFFFFFFFFFFFL;
            m23 &= Poly1305.uint32(lbelow12) ^ 0xFFFFFFFFFFFFFFFFL;
            m22 += Poly1305.uint32(lbelow10 -= lbelow11);
            m23 += Poly1305.uint32(lbelow11 -= lbelow12);
            m23 <<= 24;
            m2 += (m22 <<= 16);
            m3 <<= 51;
            long lbelow13 = l - 13;
            long lbelow14 = l - 14;
            long lbelow15 = l - 15;
            m30 = Poly1305.uint32(m[(int)(p += (lbelow13 >>= 31)) + 12]);
            m31 = 0xFF & m[(int)(p += (lbelow14 >>= 31)) + 13];
            m2 += m23;
            m32 = 0xFF & m[(int)(p += (lbelow15 >>= 31)) + 14];
            m30 &= Poly1305.uint32(lbelow13) ^ 0xFFFFFFFFFFFFFFFFL;
            m30 += Poly1305.uint32(lbelow12 -= lbelow13);
            m3 += m30;
            m31 &= Poly1305.uint32(lbelow14) ^ 0xFFFFFFFFFFFFFFFFL;
            m31 += Poly1305.uint32(lbelow13 -= lbelow14);
            m32 &= Poly1305.uint32(lbelow15) ^ 0xFFFFFFFFFFFFFFFFL;
            m3 += (m31 <<= 8);
            m32 += Poly1305.uint32(lbelow14 -= lbelow15);
            d0 = m0;
            m33 = lbelow15 + 1L;
            d1 = m1;
            m3 += (m32 <<= 16);
            d2 = m2;
            d3 = m3 += (m33 <<= 24);
            z3 = Double.longBitsToDouble(d3);
            z2 = Double.longBitsToDouble(d2);
            z1 = Double.longBitsToDouble(d1);
            z0 = Double.longBitsToDouble(d0);
            h5 += (z3 -= 5.3521788476473496E44);
            h3 += (z2 -= 1.2461512460483586E35);
            y7 = h7 + 9.194973245195333E54;
            y6 = h6 + 9.194973245195333E54;
            y1 = (h1 += (z1 -= 2.90142196707511E25)) + 2.90142196707511E25;
            y0 = (h0 += (z0 -= 6.755399441055744E15)) + 2.90142196707511E25;
            y7 -= 9.194973245195333E54;
            y6 -= 9.194973245195333E54;
            y1 -= 2.90142196707511E25;
            y0 -= 2.90142196707511E25;
            y5 = h5 + 5.3521788476473496E44;
            y4 = h4 + 5.3521788476473496E44;
            x7 = h7 - y7;
            x6 = h6 - y6;
            x1 = h1 - y1;
            x0 = h0 - y0;
            x0 += (y6 *= (double)3.67342E-39f);
            x6 += (y4 -= 5.3521788476473496E44);
            y3 = h3 + 1.2461512460483586E35;
            y2 = h2 + 1.2461512460483586E35;
            x0 += (x1 += (y7 *= (double)3.67342E-39f));
            x6 += (x7 += (y5 -= 5.3521788476473496E44));
            y3 -= 1.2461512460483586E35;
            r3low = r3low_stack;
            y2 -= 1.2461512460483586E35;
            r0low = r0low_stack;
            x5 = h5 - y5;
            r3lowx0 = r3low * x0;
            r3high = r3high_stack;
            x4 = h4 - y4;
            r0lowx6 = r0low * x6;
            r0high = r0high_stack;
            x3 = h3 - y3;
            r3highx0 = r3high * x0;
            sr1low = sr1low_stack;
            x2 = h2 - y2;
            r0highx6 = r0high * x6;
            sr1high = sr1high_stack;
            x5 += y3;
            r0lowx0 = r0low * x0;
            r1low = r1low_stack;
            h6 = r3lowx0 + r0lowx6;
            sr1lowx6 = sr1low * x6;
            r1high = r1high_stack;
            x4 += y2;
            r0highx0 = r0high * x0;
            sr2low = sr2low_stack;
            h7 = r3highx0 + r0highx6;
            sr1highx6 = sr1high * x6;
            sr2high = sr2high_stack;
            x3 += y1;
            r1lowx0 = r1low * x0;
            r2low = r2low_stack;
            h0 = r0lowx0 + sr1lowx6;
            sr2lowx6 = sr2low * x6;
            r2high = r2high_stack;
            x2 += y0;
            r1highx0 = r1high * x0;
            sr3low = sr3low_stack;
            h1 = r0highx0 + sr1highx6;
            sr2highx6 = sr2high * x6;
            sr3high = sr3high_stack;
            x4 += x5;
            r2lowx0 = r2low * x0;
            h2 = r1lowx0 + sr2lowx6;
            sr3lowx6 = sr3low * x6;
            x2 += x3;
            r2highx0 = r2high * x0;
            h3 = r1highx0 + sr2highx6;
            sr3highx6 = sr3high * x6;
            r1highx4 = r1high * x4;
            h4 = r2lowx0 + sr3lowx6;
            r1lowx4 = r1low * x4;
            r0highx4 = r0high * x4;
            h5 = r2highx0 + sr3highx6;
            r0lowx4 = r0low * x4;
            h7 += r1highx4;
            sr3highx4 = sr3high * x4;
            h6 += r1lowx4;
            sr3lowx4 = sr3low * x4;
            h5 += r0highx4;
            sr2highx4 = sr2high * x4;
            h4 += r0lowx4;
            sr2lowx4 = sr2low * x4;
            h3 += sr3highx4;
            r0lowx2 = r0low * x2;
            h2 += sr3lowx4;
            r0highx2 = r0high * x2;
            h1 += sr2highx4;
            r1lowx2 = r1low * x2;
            h0 += sr2lowx4;
            r1highx2 = r1high * x2;
            h2 += r0lowx2;
            r2lowx2 = r2low * x2;
            h3 += r0highx2;
            r2highx2 = r2high * x2;
            h4 += r1lowx2;
            sr3lowx2 = sr3low * x2;
            h5 += r1highx2;
            sr3highx2 = sr3high * x2;
            h6 += r2lowx2;
            h7 += r2highx2;
            h0 += sr3lowx2;
            h1 += sr3highx2;
        }
        y7 = h7 + 9.194973245195333E54;
        y0 = h0 + 2.90142196707511E25;
        y1 = h1 + 2.90142196707511E25;
        y2 = h2 + 1.2461512460483586E35;
        y3 = h3 + 1.2461512460483586E35;
        y4 = h4 + 5.3521788476473496E44;
        y5 = h5 + 5.3521788476473496E44;
        x7 = h7 - (y7 -= 9.194973245195333E54);
        y7 *= (double)3.67342E-39f;
        y0 -= 2.90142196707511E25;
        y1 -= 2.90142196707511E25;
        y2 -= 1.2461512460483586E35;
        y3 -= 1.2461512460483586E35;
        y4 -= 5.3521788476473496E44;
        y5 -= 5.3521788476473496E44;
        y6 = (h6 += x7) + 9.194973245195333E54;
        x0 = h0 - y0;
        x1 = h1 - y1;
        x2 = h2 - y2;
        x0 += y7;
        x3 = h3 - y3;
        x4 = h4 - y4;
        x5 = h5 - y5;
        x6 = h6 - (y6 -= 9.194973245195333E54);
        x2 += y0;
        x4 += y2;
        x0 += (y6 *= (double)3.67342E-39f);
        x6 += y4;
        x2 += (x3 += y1);
        x0 += x1;
        x4 += (x5 += y3);
        x6 += y5;
        d1 = Double.doubleToLongBits((double)(x2 += 2.901425656423924E25));
        d0 = Double.doubleToLongBits((double)(x0 += 6.755408030990331E15));
        d2 = Double.doubleToLongBits((double)(x4 += 1.2461528306116085E35));
        d3 = Double.doubleToLongBits((double)(x6 += 5.352192458942025E44));
        long f0 = d0;
        long f1 = d1;
        long bits32 = -1L;
        long f2 = d2;
        long f3 = d3;
        long f = f0 >> 32;
        long g0 = (f0 &= (bits32 >>>= 32)) + 5L;
        long g = g0 >> 32;
        g0 &= bits32;
        f = (f1 += (f &= 0xFFL)) >> 32;
        long g1 = (f1 &= bits32) + g;
        g = g1 >> 32;
        f = (f2 += (f &= 0xFFL)) >> 32;
        g1 &= bits32;
        long g2 = (f2 &= bits32) + g;
        g = g2 >> 32;
        g2 &= bits32;
        long f4 = (f3 += (f &= 0xFFL)) >> 32;
        long g3 = (f3 &= bits32) + g;
        g = g3 >> 32;
        g3 &= bits32;
        long g4 = (f4 &= 0xFFL) + g;
        long s00 = 0xFF & s[0];
        f = (g4 -= 4L) >> 63;
        long s01 = 0xFF & s[1];
        f0 &= f;
        long s02 = 0xFF & s[2];
        f1 &= f;
        f0 |= (g0 &= f ^ 0xFFFFFFFFFFFFFFFFL);
        long s03 = 0xFF & s[3];
        f2 &= f;
        long s10 = 0xFF & s[4];
        f3 &= f;
        long s11 = 0xFF & s[5];
        f1 |= (g1 &= f ^ 0xFFFFFFFFFFFFFFFFL);
        long s12 = 0xFF & s[6];
        f2 |= (g2 &= f ^ 0xFFFFFFFFFFFFFFFFL);
        f3 |= (g3 &= f ^ 0xFFFFFFFFFFFFFFFFL);
        long s13 = 0xFF & s[7];
        f0 += s00;
        long s20 = 0xFF & s[8];
        f0 += (s01 <<= 8);
        long s21 = 0xFF & s[9];
        s03 <<= 24;
        f0 += (s02 <<= 16);
        long s22 = 0xFF & s[10];
        f1 += s10;
        long s23 = 0xFF & s[11];
        f1 += (s11 <<= 8);
        long s30 = 0xFF & s[12];
        f1 += (s12 <<= 16);
        long s31 = 0xFF & s[13];
        f0 += s03;
        f1 += (s13 <<= 24);
        long s32 = 0xFF & s[14];
        f2 += s20;
        long s33 = 0xFF & s[15];
        f2 += (s21 <<= 8);
        f2 += (s22 <<= 16);
        f3 += s30;
        f3 += (s31 <<= 8);
        f3 += (s32 <<= 16);
        f2 += (s23 <<= 24);
        f3 += (s33 <<= 24);
        byte[] byArray = new byte[16];
        out[0] = (byte)f0;
        out[1] = (byte)(f0 >>= 8);
        out[2] = (byte)(f0 >>= 8);
        out[3] = (byte)(f0 >>= 8);
        out[4] = (byte)(f1 += (f0 >>= 8));
        out[5] = (byte)(f1 >>= 8);
        out[6] = (byte)(f1 >>= 8);
        out[7] = (byte)(f1 >>= 8);
        out[8] = (byte)(f2 += (f1 >>= 8));
        out[9] = (byte)(f2 >>= 8);
        out[10] = (byte)(f2 >>= 8);
        out[11] = (byte)(f2 >>= 8);
        out[12] = (byte)(f3 += (f2 >>= 8));
        out[13] = (byte)(f3 >>= 8);
        out[14] = (byte)(f3 >>= 8);
        out[15] = (byte)(f3 >>= 8);
        return out;
    }
}

