/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.util;

import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.Authorizer;
import com.pusher.client.util.ConnectionFactory;
import com.pusher.client.util.UrlEncodedConnectionFactory;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class HttpAuthorizer
implements Authorizer {
    private final URL endPoint;
    private Map<String, String> mHeaders = new HashMap<String, String>();
    private ConnectionFactory mConnectionFactory = null;

    public HttpAuthorizer(String endPoint) {
        try {
            this.endPoint = new URL(endPoint);
            this.mConnectionFactory = new UrlEncodedConnectionFactory();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not parse authentication end point into a valid URL", e);
        }
    }

    public HttpAuthorizer(String endPoint, ConnectionFactory connectionFactory) {
        try {
            this.endPoint = new URL(endPoint);
            this.mConnectionFactory = connectionFactory;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not parse authentication end point into a valid URL", e);
        }
    }

    public void setHeaders(Map<String, String> headers) {
        this.mHeaders = headers;
    }

    public Boolean isSSL() {
        return this.endPoint.getProtocol().equals("https");
    }

    @Override
    public String authorize(String channelName, String socketId) throws AuthorizationFailureException {
        try {
            String line;
            this.mConnectionFactory.setChannelName(channelName);
            this.mConnectionFactory.setSocketId(socketId);
            String body = this.mConnectionFactory.getBody();
            HashMap<String, String> defaultHeaders = new HashMap<String, String>();
            defaultHeaders.put("Content-Type", this.mConnectionFactory.getContentType());
            defaultHeaders.put("charset", this.mConnectionFactory.getCharset());
            HttpURLConnection connection = this.isSSL() != false ? (HttpsURLConnection)this.endPoint.openConnection() : (HttpURLConnection)this.endPoint.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestMethod("POST");
            defaultHeaders.putAll(this.mHeaders);
            defaultHeaders.put("Content-Length", "" + Integer.toString(body.getBytes().length));
            for (String headerName : defaultHeaders.keySet()) {
                String headerValue = (String)defaultHeaders.get(headerName);
                connection.setRequestProperty(headerName, headerValue);
            }
            connection.setUseCaches(false);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(body);
            wr.flush();
            wr.close();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuffer response = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
            rd.close();
            int responseHttpStatus = connection.getResponseCode();
            if (responseHttpStatus != 200 && responseHttpStatus != 201) {
                throw new AuthorizationFailureException(response.toString());
            }
            return response.toString();
        }
        catch (IOException e) {
            throw new AuthorizationFailureException(e);
        }
    }
}

