/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.connection.websocket;

import com.google.gson.Gson;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.connection.websocket.WebSocketListener;
import com.pusher.client.util.Factory;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnection
implements InternalConnection,
WebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(WebSocketConnection.class);
    private static final Gson GSON = new Gson();
    private static final String INTERNAL_EVENT_PREFIX = "pusher:";
    static final String PING_EVENT_SERIALIZED = "{\"event\": \"pusher:ping\"}";
    private final Factory factory;
    private final ActivityTimer activityTimer;
    private final Map<ConnectionState, Set<ConnectionEventListener>> eventListeners = new ConcurrentHashMap<ConnectionState, Set<ConnectionEventListener>>();
    private final URI webSocketUri;
    private final Proxy proxy;
    private volatile ConnectionState state = ConnectionState.DISCONNECTED;
    private WebSocketClient underlyingConnection;
    private String socketId;

    public WebSocketConnection(String url, long activityTimeout, long pongTimeout, Proxy proxy, Factory factory) throws URISyntaxException {
        this.webSocketUri = new URI(url);
        this.activityTimer = new ActivityTimer(activityTimeout, pongTimeout);
        this.proxy = proxy;
        this.factory = factory;
        for (ConnectionState state : ConnectionState.values()) {
            this.eventListeners.put(state, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
    }

    @Override
    public void connect() {
        this.factory.queueOnEventThread(new Runnable(){

            @Override
            public void run() {
                if (WebSocketConnection.this.state == ConnectionState.DISCONNECTED) {
                    try {
                        WebSocketConnection.this.underlyingConnection = WebSocketConnection.this.factory.newWebSocketClientWrapper(WebSocketConnection.this.webSocketUri, WebSocketConnection.this.proxy, WebSocketConnection.this);
                        WebSocketConnection.this.updateState(ConnectionState.CONNECTING);
                        WebSocketConnection.this.underlyingConnection.connect();
                    }
                    catch (SSLException e) {
                        WebSocketConnection.this.sendErrorToAllListeners("Error connecting over SSL", null, e);
                    }
                }
            }
        });
    }

    @Override
    public void disconnect() {
        this.factory.queueOnEventThread(new Runnable(){

            @Override
            public void run() {
                if (WebSocketConnection.this.state == ConnectionState.CONNECTED) {
                    WebSocketConnection.this.updateState(ConnectionState.DISCONNECTING);
                    WebSocketConnection.this.underlyingConnection.close();
                }
            }
        });
    }

    @Override
    public void bind(ConnectionState state, ConnectionEventListener eventListener) {
        this.eventListeners.get((Object)state).add(eventListener);
    }

    @Override
    public boolean unbind(ConnectionState state, ConnectionEventListener eventListener) {
        return this.eventListeners.get((Object)state).remove(eventListener);
    }

    @Override
    public ConnectionState getState() {
        return this.state;
    }

    @Override
    public void sendMessage(final String message) {
        this.factory.queueOnEventThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (WebSocketConnection.this.state == ConnectionState.CONNECTED) {
                        WebSocketConnection.this.underlyingConnection.send(message);
                    } else {
                        WebSocketConnection.this.sendErrorToAllListeners("Cannot send a message while in " + (Object)((Object)WebSocketConnection.this.state) + " state", null, null);
                    }
                }
                catch (Exception e) {
                    WebSocketConnection.this.sendErrorToAllListeners("An exception occurred while sending message [" + message + "]", null, e);
                }
            }
        });
    }

    @Override
    public String getSocketId() {
        return this.socketId;
    }

    private void updateState(ConnectionState newState) {
        log.debug("State transition requested, current [" + (Object)((Object)this.state) + "], new [" + (Object)((Object)newState) + "]");
        final ConnectionStateChange change = new ConnectionStateChange(this.state, newState);
        this.state = newState;
        HashSet interestedListeners = new HashSet();
        interestedListeners.addAll(this.eventListeners.get((Object)ConnectionState.ALL));
        interestedListeners.addAll(this.eventListeners.get((Object)newState));
        for (final ConnectionEventListener listener : interestedListeners) {
            this.factory.queueOnEventThread(new Runnable(){

                @Override
                public void run() {
                    listener.onConnectionStateChange(change);
                }
            });
        }
    }

    private void handleEvent(String event, String wholeMessage) {
        if (event.startsWith(INTERNAL_EVENT_PREFIX)) {
            this.handleInternalEvent(event, wholeMessage);
        } else {
            this.factory.getChannelManager().onMessage(event, wholeMessage);
        }
    }

    private void handleInternalEvent(String event, String wholeMessage) {
        if (event.equals("pusher:connection_established")) {
            this.handleConnectionMessage(wholeMessage);
        } else if (event.equals("pusher:error")) {
            this.handleError(wholeMessage);
        }
    }

    private void handleConnectionMessage(String message) {
        Map jsonObject = (Map)GSON.fromJson(message, Map.class);
        String dataString = (String)jsonObject.get("data");
        Map dataMap = (Map)GSON.fromJson(dataString, Map.class);
        this.socketId = (String)dataMap.get("socket_id");
        this.updateState(ConnectionState.CONNECTED);
    }

    private void handleError(String wholeMessage) {
        Map json = (Map)GSON.fromJson(wholeMessage, Map.class);
        Object data = json.get("data");
        Map dataMap = data instanceof String ? (Map)GSON.fromJson((String)data, Map.class) : (Map)data;
        String message = (String)dataMap.get("message");
        Object codeObject = dataMap.get("code");
        String code = null;
        if (codeObject != null) {
            code = String.valueOf(Math.round((Double)codeObject));
        }
        this.sendErrorToAllListeners(message, code, null);
    }

    private void sendErrorToAllListeners(final String message, final String code, final Exception e) {
        HashSet<ConnectionEventListener> allListeners = new HashSet<ConnectionEventListener>();
        for (Set<ConnectionEventListener> listenersForState : this.eventListeners.values()) {
            allListeners.addAll(listenersForState);
        }
        for (final ConnectionEventListener listener : allListeners) {
            this.factory.queueOnEventThread(new Runnable(){

                @Override
                public void run() {
                    listener.onError(message, code, e);
                }
            });
        }
    }

    @Override
    public void onOpen(ServerHandshake handshakedata) {
    }

    @Override
    public void onMessage(final String message) {
        this.activityTimer.activity();
        this.factory.queueOnEventThread(new Runnable(){

            @Override
            public void run() {
                Map map = (Map)GSON.fromJson(message, Map.class);
                String event = (String)map.get("event");
                WebSocketConnection.this.handleEvent(event, message);
            }
        });
    }

    @Override
    public void onClose(final int code, final String reason, final boolean remote) {
        this.activityTimer.cancelTimeouts();
        this.factory.queueOnEventThread(new Runnable(){

            @Override
            public void run() {
                if (WebSocketConnection.this.state != ConnectionState.DISCONNECTED) {
                    WebSocketConnection.this.updateState(ConnectionState.DISCONNECTED);
                } else {
                    log.error("Received close from underlying socket when already disconnected. Close code [" + code + "], Reason [" + reason + "], Remote [" + remote + "]");
                }
                WebSocketConnection.this.factory.shutdownThreads();
            }
        });
    }

    @Override
    public void onError(final Exception ex) {
        this.factory.queueOnEventThread(new Runnable(){

            @Override
            public void run() {
                WebSocketConnection.this.sendErrorToAllListeners("An exception was thrown by the websocket", null, ex);
            }
        });
    }

    private class ActivityTimer {
        private final long activityTimeout;
        private final long pongTimeout;
        private Future<?> pingTimer;
        private Future<?> pongTimer;

        public ActivityTimer(long activityTimeout, long pongTimeout) {
            this.activityTimeout = activityTimeout;
            this.pongTimeout = pongTimeout;
        }

        public synchronized void activity() {
            if (this.pongTimer != null) {
                this.pongTimer.cancel(true);
            }
            if (this.pingTimer != null) {
                this.pingTimer.cancel(false);
            }
            this.pingTimer = WebSocketConnection.this.factory.getTimers().schedule(new Runnable(){

                @Override
                public void run() {
                    log.debug("Sending ping");
                    WebSocketConnection.this.sendMessage(WebSocketConnection.PING_EVENT_SERIALIZED);
                    ActivityTimer.this.schedulePongCheck();
                }
            }, this.activityTimeout, TimeUnit.MILLISECONDS);
        }

        public synchronized void cancelTimeouts() {
            if (this.pingTimer != null) {
                this.pingTimer.cancel(false);
            }
            if (this.pongTimer != null) {
                this.pongTimer.cancel(false);
            }
        }

        private synchronized void schedulePongCheck() {
            if (this.pongTimer != null) {
                this.pongTimer.cancel(false);
            }
            this.pongTimer = WebSocketConnection.this.factory.getTimers().schedule(new Runnable(){

                @Override
                public void run() {
                    log.debug("Timed out awaiting pong from server - disconnecting");
                    WebSocketConnection.this.disconnect();
                }
            }, this.pongTimeout, TimeUnit.MILLISECONDS);
        }
    }
}

