/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.google.gson.Gson;
import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.Authorizer;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.PresenceChannel;
import com.pusher.client.channel.PresenceChannelEventListener;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.User;
import com.pusher.client.channel.impl.PrivateChannelImpl;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.util.Factory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PresenceChannelImpl
extends PrivateChannelImpl
implements PresenceChannel {
    private static final String MEMBER_ADDED_EVENT = "pusher_internal:member_added";
    private static final String MEMBER_REMOVED_EVENT = "pusher_internal:member_removed";
    private final Map<String, User> idToUserMap = Collections.synchronizedMap(new LinkedHashMap());
    private String myUserID;

    public PresenceChannelImpl(InternalConnection connection, String channelName, Authorizer authorizer, Factory factory) {
        super(connection, channelName, authorizer, factory);
    }

    @Override
    public Set<User> getUsers() {
        return new LinkedHashSet<User>(this.idToUserMap.values());
    }

    @Override
    public User getMe() {
        return this.idToUserMap.get(this.myUserID);
    }

    @Override
    public void onMessage(String event, String message) {
        super.onMessage(event, message);
        if (event.equals("pusher_internal:subscription_succeeded")) {
            this.handleSubscriptionSuccessfulMessage(message);
        } else if (event.equals(MEMBER_ADDED_EVENT)) {
            this.handleMemberAddedEvent(message);
        } else if (event.equals(MEMBER_REMOVED_EVENT)) {
            this.handleMemberRemovedEvent(message);
        }
    }

    @Override
    public String toSubscribeMessage() {
        String authResponse = this.getAuthResponse();
        try {
            Map authResponseMap = (Map)new Gson().fromJson(authResponse, Map.class);
            String authKey = (String)authResponseMap.get("auth");
            Object channelData = authResponseMap.get("channel_data");
            this.storeMyUserId(channelData);
            LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
            jsonObject.put("event", "pusher:subscribe");
            LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
            dataMap.put("channel", this.name);
            dataMap.put("auth", authKey);
            dataMap.put("channel_data", (String)channelData);
            jsonObject.put("data", dataMap);
            String json = new Gson().toJson(jsonObject);
            return json;
        }
        catch (Exception e) {
            throw new AuthorizationFailureException("Unable to parse response from Authorizer: " + authResponse, e);
        }
    }

    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        if (!(listener instanceof PresenceChannelEventListener)) {
            throw new IllegalArgumentException("Only instances of PresenceChannelEventListener can be bound to a presence channel");
        }
        super.bind(eventName, listener);
    }

    @Override
    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^(?!presence-).*"};
    }

    @Override
    public String toString() {
        return String.format("[Presence Channel: name=%s]", this.name);
    }

    private void handleSubscriptionSuccessfulMessage(String message) {
        Map presenceMap = PresenceChannelImpl.extractPresenceMapFrom(message);
        List ids = (List)presenceMap.get("ids");
        Map hash = (Map)presenceMap.get("hash");
        for (String id : ids) {
            String userData = hash.get(id) != null ? hash.get(id).toString() : null;
            User user = new User(id, userData);
            this.idToUserMap.put(id, user);
        }
        ChannelEventListener listener = this.getEventListener();
        if (listener != null) {
            PresenceChannelEventListener presenceListener = (PresenceChannelEventListener)listener;
            presenceListener.onUsersInformationReceived(this.getName(), this.getUsers());
        }
    }

    private void handleMemberAddedEvent(String message) {
        Map dataMap = PresenceChannelImpl.extractDataMapFrom(message);
        String id = (String)dataMap.get("user_id");
        String userData = dataMap.get("user_info") != null ? dataMap.get("user_info").toString() : null;
        User user = new User(id, userData);
        this.idToUserMap.put(id, user);
        ChannelEventListener listener = this.getEventListener();
        if (listener != null) {
            PresenceChannelEventListener presenceListener = (PresenceChannelEventListener)listener;
            presenceListener.userSubscribed(this.getName(), user);
        }
    }

    private void handleMemberRemovedEvent(String message) {
        Map dataMap = PresenceChannelImpl.extractDataMapFrom(message);
        String id = (String)dataMap.get("user_id");
        User user = this.idToUserMap.remove(id);
        ChannelEventListener listener = this.getEventListener();
        if (listener != null) {
            PresenceChannelEventListener presenceListener = (PresenceChannelEventListener)listener;
            presenceListener.userUnsubscribed(this.getName(), user);
        }
    }

    private static Map extractDataMapFrom(String message) {
        Gson gson = new Gson();
        Map jsonObject = (Map)gson.fromJson(message, Map.class);
        String dataString = (String)jsonObject.get("data");
        Map dataMap = (Map)gson.fromJson(dataString, Map.class);
        return dataMap;
    }

    private static Map extractPresenceMapFrom(String message) {
        Map dataMap = PresenceChannelImpl.extractDataMapFrom(message);
        Map presenceMap = (Map)dataMap.get("presence");
        return presenceMap;
    }

    private void storeMyUserId(Object channelData) {
        Map channelDataMap = (Map)new Gson().fromJson((String)channelData, Map.class);
        this.myUserID = (String)channelDataMap.get("user_id");
    }
}

