/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp.events.custom;

import com.pushchamp.PushChamp;
import java.util.Locale;
import java.util.Map;

public class PushChampEventAnalyser {
    final int maxNumAttributes = 30;
    final int maxStringLength = 200;
    boolean debuggerEnabled = PushChamp.isDebuggable();

    public String limitStringLength(String eventName) {
        if (eventName.length() > this.maxStringLength) {
            String message = String.format(Locale.US, "String is too long, stripping  %d data", this.maxStringLength);
            this.handleException(new IllegalArgumentException(message));
            return eventName.substring(0, this.maxStringLength);
        }
        return eventName;
    }

    public boolean isNull(Object object, String paramName) {
        if (object == null) {
            this.handleException(new NullPointerException(paramName + " must not be null"));
            return true;
        }
        return false;
    }

    public boolean checkForEventAttributeSize(Map<String, Object> attributeMap, String key) {
        if (attributeMap.size() >= this.maxNumAttributes && !attributeMap.containsKey(key)) {
            String message = String.format(Locale.US, "Max Limit of %d attributes reached, skipping attribute", this.maxNumAttributes);
            this.handleException(new IllegalArgumentException(message));
            return true;
        }
        return false;
    }

    private void handleException(RuntimeException ex) {
        if (this.debuggerEnabled) {
            throw ex;
        }
        PushChamp.getLogger().e("PushChampEventAnalyser", "Invalid user input detected", ex);
    }
}

