/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp.events;

import android.content.Context;
import android.content.SharedPreferences;
import com.pushchamp.PushchampPreferences;
import com.pushchamp.database.DatabaseHandler;
import com.pushchamp.database.EventsModel;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class SessionGenerator {
    public static SessionGenerator getInstance() {
        return PushChampHelper.INSTANCE;
    }

    void checkForSessionChange(Context context) {
        long sessionInterval;
        long diffMinutes;
        long sessionStopTime;
        boolean isFirstRun = context.getSharedPreferences("PushchampPrefs", 0).getBoolean("FIRSTRUN", true);
        String appName = PushchampPreferences.getAppName(context);
        String candidateChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
        if (isFirstRun) {
            String ssid = this.generateRandomChars(candidateChars, 32);
            SharedPreferences.Editor editor = context.getSharedPreferences("PushchampPrefs", 0).edit();
            editor.putBoolean("FIRSTRUN", false);
            editor.putLong("ts", System.currentTimeMillis());
            editor.commit();
            DatabaseHandler databaseHandler = new DatabaseHandler(context);
            databaseHandler.addEvent(new EventsModel(ssid, appName, "session_start", "userEvent", System.currentTimeMillis(), 0L, "android", new JSONObject().toString()));
            databaseHandler.close();
            context.getSharedPreferences("PushchampPrefs", 0).edit().putString("sessionID", ssid).apply();
        }
        if ((sessionStopTime = context.getSharedPreferences("PushchampPrefs", 0).getLong("appStopTime", 0L)) != 0L && TimeUnit.MINUTES.toMillis(diffMinutes = (sessionInterval = System.currentTimeMillis() - sessionStopTime) / 60000L % 60L) >= TimeUnit.MINUTES.toMillis(15L)) {
            String previousSessionId = context.getSharedPreferences("PushchampPrefs", 0).getString("sessionID", "");
            String ssid = this.generateRandomChars(candidateChars, 32);
            context.getSharedPreferences("PushchampPrefs", 0).edit().putString("sessionID", ssid).apply();
            context.getSharedPreferences("PushchampPrefs", 0).edit().putLong("appStopTime", System.currentTimeMillis()).commit();
            long tfsValueFieldEndEvent = TimeUnit.MILLISECONDS.toSeconds(sessionStopTime - context.getSharedPreferences("PushchampPrefs", 0).getLong("ts", 0L));
            SharedPreferences.Editor editor = context.getSharedPreferences("PushchampPrefs", 0).edit();
            editor.putLong("ts", System.currentTimeMillis());
            editor.commit();
            DatabaseHandler databaseHandler = new DatabaseHandler(context);
            databaseHandler.addEvent(new EventsModel(previousSessionId, appName, "session_end", "userEvent", sessionStopTime, tfsValueFieldEndEvent, "android", new JSONObject().toString()));
            databaseHandler.addEvent(new EventsModel(ssid, appName, "session_start", "userEvent", System.currentTimeMillis(), 0L, "android", new JSONObject().toString()));
            databaseHandler.close();
        }
    }

    String generateRandomChars(String candidateChars, int length) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(candidateChars.charAt(random.nextInt(candidateChars.length())));
        }
        return sb.toString();
    }

    private static class PushChampHelper {
        private static final SessionGenerator INSTANCE = new SessionGenerator();

        private PushChampHelper() {
        }
    }
}

