/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp.events;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.pushchamp.PushChamp;
import com.pushchamp.database.DatabaseHandler;
import com.pushchamp.utils.Constants;
import com.pushchamp.utils.StringUtils;
import com.pushchamp.utils.URLConnection;
import com.pushchamp.utils.VersionInfo;
import java.net.HttpURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventApiCall {
    public void startEventCall(final Context mContext, final String subscriptionId) {
        Thread background = new Thread(new Runnable(){
            JSONObject emptyArray = new JSONObject();
            int statusCode;
            public static final String TAG = "EventLog";
            private final Handler handler = new Handler(){

                public void handleMessage(Message msg) {
                    block9: {
                        String result = msg.getData().getString("message");
                        PushChamp.getLogger().d("EventLogTrack Response", "" + result);
                        if (null != result || !result.equals("")) {
                            JSONObject mainObject = null;
                            if (statusCode == 200) {
                                try {
                                    mainObject = new JSONObject(result);
                                    JSONObject eventObject = mainObject.getJSONObject("data");
                                    boolean status = mainObject.optBoolean("status");
                                    DatabaseHandler databaseHandler = new DatabaseHandler(mContext);
                                    if (!status) break block9;
                                    Cursor cursor = databaseHandler.getEvents();
                                    if (cursor.moveToFirst()) {
                                        while (!cursor.isAfterLast()) {
                                            try {
                                                databaseHandler.deleteEvent(cursor.getString(cursor.getColumnIndex("id")));
                                            }
                                            catch (Exception e) {
                                                PushChamp.getLogger().w(1.TAG, Constants.EXCEPTION_MESSAGE, e);
                                            }
                                            cursor.moveToNext();
                                        }
                                    }
                                    if (cursor != null) {
                                        cursor.close();
                                    }
                                    databaseHandler.close();
                                }
                                catch (JSONException e) {
                                    PushChamp.getLogger().w(1.TAG, Constants.EXCEPTION_MESSAGE, e);
                                }
                            }
                        }
                    }
                }
            };

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block19: {
                    try {
                        JSONObject deviceJSON = new JSONObject();
                        JSONArray jsonArray = new JSONArray();
                        if (!Thread.currentThread().isInterrupted()) {
                            HttpURLConnection conn = null;
                            DatabaseHandler databaseHandler = new DatabaseHandler(mContext);
                            if (databaseHandler.getEventsCount() <= 5) break block19;
                            Cursor cursor = databaseHandler.getEvents();
                            if (cursor.moveToFirst()) {
                                while (!cursor.isAfterLast()) {
                                    try {
                                        deviceJSON = new JSONObject();
                                        deviceJSON.put("ssid", (Object)cursor.getString(cursor.getColumnIndex("ssid")));
                                        deviceJSON.put("sid", (Object)subscriptionId);
                                        deviceJSON.put("app", (Object)cursor.getString(cursor.getColumnIndex("app")));
                                        deviceJSON.put("ev", (Object)cursor.getString(cursor.getColumnIndex("ev")));
                                        deviceJSON.put("ty", (Object)cursor.getString(cursor.getColumnIndex("ty")));
                                        deviceJSON.put("ts", cursor.getLong(cursor.getColumnIndex("ts")));
                                        deviceJSON.put("tfs", cursor.getLong(cursor.getColumnIndex("tfs")));
                                        deviceJSON.put("pf", (Object)cursor.getString(cursor.getColumnIndex("pf")));
                                        if (cursor.getString(cursor.getColumnIndex("et")) == null || cursor.getString(cursor.getColumnIndex("pf")).equalsIgnoreCase("")) {
                                            deviceJSON.put("et", (Object)this.emptyArray);
                                        } else {
                                            deviceJSON.put("et", (Object)new JSONObject(cursor.getString(cursor.getColumnIndex("et"))));
                                        }
                                        jsonArray.put((Object)deviceJSON);
                                    }
                                    catch (Exception e) {
                                        PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
                                    }
                                    cursor.moveToNext();
                                }
                            }
                            if (cursor != null) {
                                cursor.close();
                            }
                            String message = jsonArray.toString();
                            PushChamp.getLogger().d("EventLog Send Request", "" + message);
                            databaseHandler.close();
                            String response = null;
                            try {
                                conn = new URLConnection.Builder().setApi(VersionInfo.API_LOG_EVENT).setMessageBody(message).build();
                                if (conn != null) {
                                    conn.connect();
                                    this.statusCode = conn.getResponseCode();
                                    response = this.statusCode == 200 ? StringUtils.inputStreamToString(conn.getInputStream()) : "";
                                } else {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            catch (Exception e) {
                                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
                                Thread.currentThread().interrupt();
                            }
                            finally {
                                if (conn != null) {
                                    conn.disconnect();
                                }
                            }
                            this.threadMsg(response);
                            break block19;
                        }
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (Exception e) {
                        PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable t) {
                        PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, t);
                        Thread.currentThread().interrupt();
                    }
                }
            }

            private void threadMsg(String msg) {
                if (msg != null && !msg.equals("")) {
                    Message msgObj = this.handler.obtainMessage();
                    Bundle b = new Bundle();
                    b.putString("message", msg);
                    msgObj.setData(b);
                    this.handler.sendMessage(msgObj);
                }
            }
        });
        background.start();
    }
}

