/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp.events;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.pushchamp.PushchampPreferences;
import com.pushchamp.database.DatabaseHandler;
import com.pushchamp.database.EventsModel;
import com.pushchamp.events.EventApiCall;
import com.pushchamp.events.SessionGenerator;
import com.pushchamp.utils.ConnectionDetector;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

@TargetApi(value=14)
public class ActivityLifecycleHandler
implements Application.ActivityLifecycleCallbacks {
    Activity lifeCycleContext;
    long tsValueField;
    long passingTs;
    JSONObject deviceJSON;
    JSONArray jsonArray;
    JSONObject emptyArray;
    String subscriptionId;
    String activityName;
    long tfsValueField;
    private String ssid;
    private ConnectionDetector mCheckconnection;
    private String appName;

    public void onActivityCreated(Activity activity, Bundle bundle) {
        SharedPreferences sharedPreferences = activity.getSharedPreferences("PushchampPrefs", 0);
        this.activityName = activity.getComponentName().getShortClassName().substring(activity.getComponentName().getShortClassName().lastIndexOf(".") + 1).trim().toString();
        this.lifeCycleContext = activity;
        this.mCheckconnection = new ConnectionDetector((Context)activity);
        this.deviceJSON = new JSONObject();
        this.jsonArray = new JSONArray();
        this.subscriptionId = this.lifeCycleContext.getSharedPreferences("PushchampPrefs", 0).getString("subscription_id", null);
        this.tsValueField = System.currentTimeMillis();
        this.tfsValueField = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - sharedPreferences.getLong("ts", 0L));
        this.emptyArray = new JSONObject();
        this.appName = PushchampPreferences.APP_NAME;
        if (this.appName.equals("")) {
            ApplicationInfo ai = null;
            try {
                ai = this.lifeCycleContext.getPackageManager().getApplicationInfo(this.lifeCycleContext.getPackageName(), 128);
                this.appName = (String)ai.metaData.get("pushchamp_app_id");
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.ssid = this.lifeCycleContext.getSharedPreferences("PushchampPrefs", 0).getString("sessionID", "");
        this.passingTs = System.currentTimeMillis();
        DatabaseHandler databaseHandler = new DatabaseHandler((Context)activity);
        databaseHandler.addEvent(new EventsModel(this.ssid, this.appName, this.activityName, "userEvent", this.passingTs, this.tfsValueField, "android", this.emptyArray.toString()));
        databaseHandler.close();
        if (this.mCheckconnection.isConnectingToInternet() && this.subscriptionId != null && this.subscriptionId.length() > 0) {
            new EventApiCall().startEventCall((Context)this.lifeCycleContext, this.lifeCycleContext.getSharedPreferences("PushchampPrefs", 0).getString("subscription_id", null));
        }
    }

    public void onActivityStarted(Activity activity) {
        this.lifeCycleContext = activity;
    }

    public void onActivityResumed(Activity activity) {
        this.lifeCycleContext = activity;
        SessionGenerator.getInstance().checkForSessionChange((Context)activity);
    }

    public void onActivityPaused(Activity activity) {
        this.lifeCycleContext = activity;
        activity.getSharedPreferences("PushchampPrefs", 0).edit().putLong("appStopTime", System.currentTimeMillis()).commit();
    }

    public void onActivityStopped(Activity activity) {
        this.lifeCycleContext = activity;
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

