/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.common.GoogleApiAvailability;
import com.pushchamp.PushChamp;
import com.pushchamp.PushchampPreferences;
import com.pushchamp.PushchampRegistrationService;
import com.pushchamp.PushchampWrapper;
import com.pushchamp.utils.Constants;
import java.util.HashMap;

public class PushchampSubscription {
    private static final String TAG = PushchampSubscription.class.getSimpleName();
    private String app;
    private Context context;
    private SharedPreferences sharedPrefs;
    private static final String EMAIL_KEY = "email";
    private static final String MOBILE_KEY = "mobile";
    private static final String USERID_KEY = "unique_id";

    public PushchampSubscription(Context ctx) {
        this.context = ctx;
        this.sharedPrefs = ctx.getSharedPreferences("PushchampPrefs", 0);
    }

    public PushchampSubscription(Context ctx, String app) {
        this.context = ctx;
        this.app = app;
        this.sharedPrefs = ctx.getSharedPreferences("PushchampPrefs", 0);
    }

    public void register() {
        ApplicationInfo ai = null;
        try {
            ai = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
            PushchampPreferences.APP_NAME = this.app = (String)ai.metaData.get("pushchamp_app_id");
            this.register((String)ai.metaData.get("google_sender_id"));
        }
        catch (PackageManager.NameNotFoundException e) {
            PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
        }
        catch (Exception e) {
            PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
        }
    }

    public void register(String sender_id) {
        String subscription_id;
        long applicationStartTime = System.currentTimeMillis();
        this.sharedPrefs.edit().putLong("appStartTime", applicationStartTime).commit();
        if (this.context != null && this.checkPlayServices() && ((subscription_id = this.sharedPrefs.getString("subscription_id", "")) == null || subscription_id.equals(""))) {
            Intent intent = new Intent(this.context, PushchampRegistrationService.class);
            intent.putExtra("SENDER_ID", sender_id);
            intent.putExtra("APP_ID", this.app);
            this.context.getSharedPreferences("PushchampPrefs", 0).edit().putString("gcm_Sender_id", sender_id).apply();
            this.context.startService(intent);
        }
    }

    public void updateTags(HashMap<String, String> add_tags, String[] delete_tags) {
        String subscription_id = this.sharedPrefs.getString("subscription_id", "");
        if (subscription_id == null) {
            PushChamp.getLogger().e(TAG, "Update tag failed: Device not registered");
            return;
        }
        PushchampWrapper pc = new PushchampWrapper(this.context, this.app, null, add_tags, delete_tags, null, null);
        pc.execute(new Void[0]);
    }

    public void addEmail(String email) {
        this.addTag(EMAIL_KEY, email);
    }

    public void addMobile(String mobile) {
        this.addTag(MOBILE_KEY, mobile);
    }

    public void addUserID(String uid) {
        this.addTag(USERID_KEY, uid);
    }

    public void deleteEmail() {
        this.deleteTag(EMAIL_KEY);
    }

    public void deleteMobile() {
        this.deleteTag(MOBILE_KEY);
    }

    public void deleteUserID() {
        this.deleteTag(USERID_KEY);
    }

    public void addTag(String key, String value) {
        String subscription_id = this.sharedPrefs.getString("subscription_id", "");
        if (subscription_id == null) {
            PushChamp.getLogger().e(TAG, "Update tag failed: Device not registered");
            return;
        }
        HashMap<String, String> add_tags = new HashMap<String, String>();
        add_tags.put(key, value);
        PushchampWrapper pc = new PushchampWrapper(this.context, this.app, null, add_tags, null, null, null);
        pc.execute(new Void[0]);
    }

    public void deleteTag(String key) {
        String subscription_id = this.sharedPrefs.getString("subscription_id", "");
        if (subscription_id == null) {
            PushChamp.getLogger().e(TAG, "Update tag failed: Device not registered");
            return;
        }
        String[] delete_tags = new String[]{key};
        PushchampWrapper pc = new PushchampWrapper(this.context, this.app, null, null, delete_tags, null, null);
        pc.execute(new Void[0]);
    }

    public void addGroups(String[] add_groups) {
        String subscription_id = this.sharedPrefs.getString("subscription_id", "");
        if (subscription_id == null) {
            PushChamp.getLogger().e(TAG, "Add groups failed: Device not registered");
            return;
        }
        PushchampWrapper pc = new PushchampWrapper(this.context, this.app, null, null, null, add_groups, null);
        pc.execute(new Void[0]);
    }

    public void deleteGroups(String[] delete_groups) {
        String subscription_id = this.sharedPrefs.getString("subscription_id", "");
        if (subscription_id == null) {
            PushChamp.getLogger().e(TAG, "Delete groups failed: Device not registered");
            return;
        }
        PushchampWrapper pc = new PushchampWrapper(this.context, this.app, null, null, null, null, delete_groups);
        pc.execute(new Void[0]);
    }

    private boolean checkPlayServices() {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int resultCode = apiAvailability.isGooglePlayServicesAvailable(this.context);
        if (resultCode != 0) {
            PushChamp.getLogger().i(TAG, "This device is not supported for GCM.");
            return false;
        }
        return true;
    }
}

