/*
 * Decompiled with CFR 0.152.
 */
package com.pushchamp;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import com.pushchamp.PushChamp;
import com.pushchamp.PushchampActivity;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PushchampNotification {
    private Context context;
    private boolean isSilent;
    private boolean isShowable;
    private String message;
    private String header;
    private int smallIcon;
    private String largeIcon;
    private Intent pendingIntent;
    private String notification_id;
    private NotificationCompat.Action[] actions;
    private NotificationCompat.Style notification_style;
    private static final String NOTIFICATION_ID_KEY = "_pc_nid";
    private static final String TAG = PushchampNotification.class.getSimpleName();

    public PushchampNotification(Context context, Bundle data) {
        this.context = context;
        this.isSilent = data.getBoolean("sl", false);
        this.message = data.getString("mg");
        this.header = data.getString("hd");
        String s_icon = data.getString("si");
        this.smallIcon = 0;
        try {
            this.smallIcon = this.context.getResources().getIdentifier(s_icon, "drawable", this.context.getPackageName());
        }
        catch (Exception e) {
            PushChamp.getLogger().w(TAG, "Unable to find icon " + s_icon + " in resources");
        }
        if (this.smallIcon == 0) {
            PushChamp.getLogger().w(TAG, "Icon not found in resources.");
            try {
                this.smallIcon = 17301659;
            }
            catch (Exception e) {
                PushChamp.getLogger().e(TAG, "Default icon not found in resources. Unable to process notification.");
            }
        }
        this.largeIcon = data.getString("li");
        this.isShowable = this.smallIcon != 0 && !this.isSilent;
        this.notification_id = data.getString(NOTIFICATION_ID_KEY);
        this.pendingIntent = this.makePendingIntent(data, "tc", "td");
        this.notification_style = this.makeNotifStyle(data);
        this.actions = this.addActions(data);
    }

    public void show() {
        block9: {
            try {
                if (!this.isShowable) break block9;
                Uri defaultSoundUri = RingtoneManager.getDefaultUri((int)2);
                NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(this.context).setSmallIcon(this.smallIcon).setContentTitle((CharSequence)this.header).setContentText((CharSequence)this.message).setAutoCancel(true).setSound(defaultSoundUri);
                if (this.largeIcon != null) {
                    Bitmap lrgIcn = PushchampNotification.getBitmapFromURL(this.largeIcon);
                    notificationBuilder.setLargeIcon(lrgIcn);
                }
                if (this.pendingIntent != null) {
                    this.pendingIntent.addFlags(0x4000000);
                    PendingIntent pi = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)this.pendingIntent, (int)0x40000000);
                    notificationBuilder.setContentIntent(pi);
                }
                if (this.notification_style != null) {
                    notificationBuilder.setStyle(this.notification_style);
                }
                if (this.actions != null) {
                    for (int i = 0; i < this.actions.length; ++i) {
                        notificationBuilder.addAction(this.actions[i]);
                    }
                }
                try {
                    Intent ci = new Intent(this.context, PushchampActivity.class);
                    ci.putExtra("event", "deleted");
                    ci.putExtra("nid", this.notification_id);
                    PendingIntent deleteIntent = PendingIntent.getActivity((Context)this.context, (int)1, (Intent)ci, (int)0x10000000);
                    notificationBuilder.setDeleteIntent(deleteIntent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
                notificationManager.notify(this.notification_id, new Random().nextInt(), notificationBuilder.build());
            }
            catch (Exception e) {
                PushChamp.getLogger().e(TAG, "Notification show Error: " + e.toString());
            }
        }
    }

    public Intent makePendingIntent(Bundle data, String class_key, String data_key) {
        try {
            Intent pi = null;
            if (data.getString(class_key) == null) {
                return null;
            }
            String target_class = data.getString(class_key);
            pi = new Intent(this.context, PushchampActivity.class);
            pi.putExtra("event", "opened");
            pi.putExtra("nid", this.notification_id);
            pi.putExtra("class_name", target_class);
            String extra_data = data.getString(data_key);
            if (extra_data != null) {
                JSONObject target_data = new JSONObject(data.getString(data_key));
                Iterator keys = target_data.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (target_data.get(key) instanceof String) {
                        pi.putExtra(key, (String)target_data.get(key));
                    }
                    if (target_data.get(key) instanceof Integer) {
                        pi.putExtra(key, (Serializable)((Integer)target_data.get(key)));
                    }
                    if (!(target_data.get(key) instanceof Boolean)) continue;
                    pi.putExtra(key, (Serializable)((Boolean)target_data.get(key)));
                }
            }
            if (pi != null) {
                new PendingIntent.OnFinished(){

                    public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
                    }
                };
            }
            return pi;
        }
        catch (JSONException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public NotificationCompat.Action[] addActions(Bundle data) {
        try {
            NotificationCompat.Action[] action_items = null;
            if (data.getString("ac") == null) {
                return null;
            }
            JSONArray actions = new JSONArray(data.getString("ac"));
            int total_actions = actions.length() > 2 ? 3 : actions.length();
            action_items = new NotificationCompat.Action[total_actions];
            for (int i = 0; i < total_actions; ++i) {
                NotificationCompat.Action ac;
                JSONObject obj = actions.getJSONObject(i);
                String obj_class = obj.getString("cl");
                String obj_title = obj.getString("tl");
                int obj_icon = 0;
                try {
                    obj_icon = this.context.getResources().getIdentifier(obj.getString("ic"), "drawable", this.context.getPackageName());
                }
                catch (Exception e) {
                    PushChamp.getLogger().w(TAG, "Action button icon error. Unable to add action button.");
                    continue;
                }
                JSONObject obj_extra = null;
                try {
                    obj_extra = obj.getJSONObject("dt");
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                if (obj_class == null || obj_icon == 0 || obj_title == null) continue;
                Intent ai = new Intent(this.context, Class.forName(obj_class));
                if (obj_extra != null) {
                    Iterator keys = obj_extra.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if (obj_extra.get(key) instanceof String) {
                            ai.putExtra(key, (String)obj_extra.get(key));
                        }
                        if (obj_extra.get(key) instanceof Integer) {
                            ai.putExtra(key, (Serializable)((Integer)obj_extra.get(key)));
                        }
                        if (!(obj_extra.get(key) instanceof Boolean)) continue;
                        ai.putExtra(key, (Serializable)((Boolean)obj_extra.get(key)));
                    }
                }
                PendingIntent pi = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)ai, (int)0x40000000);
                ai.addFlags(0x4000000);
                action_items[i] = ac = new NotificationCompat.Action(obj_icon, (CharSequence)obj_title, pi);
            }
            return action_items;
        }
        catch (JSONException e) {
            PushChamp.getLogger().w(TAG, "Tag JSON error: " + e.toString());
            return null;
        }
        catch (ClassNotFoundException e) {
            PushChamp.getLogger().w(TAG, "Tag Class error: " + e.toString());
            return null;
        }
        catch (Exception e) {
            PushChamp.getLogger().w(TAG, "Tag error: " + e.toString());
            return null;
        }
    }

    public NotificationCompat.Style makeNotifStyle(Bundle data) {
        String bigText;
        String imgUrl;
        Bitmap imgBit;
        NotificationCompat.BigTextStyle style = null;
        if (data.getString("st") != null && data.getString("st").equals("big_picture") && (imgBit = PushchampNotification.getBitmapFromURL(imgUrl = data.getString("bi"))) != null) {
            style = new NotificationCompat.BigPictureStyle().bigPicture(imgBit).setSummaryText((CharSequence)data.getString("mg"));
        }
        if (data.getString("st") != null && data.getString("st").equals("big_text") && (bigText = data.getString("bt")) != null) {
            style = new NotificationCompat.BigTextStyle().bigText((CharSequence)bigText);
        }
        return style;
    }

    public static Bitmap getBitmapFromURL(String src) {
        if (src == null) {
            return null;
        }
        try {
            URL url = new URL(src);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap myBitmap = BitmapFactory.decodeStream((InputStream)input);
            return myBitmap;
        }
        catch (IOException e) {
            return null;
        }
    }
}

