package com.pushchamp.utils;


import com.pushchamp.PushChamp;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;

/**
 * Created by munnaz on 27/12/16.
 */

public class URLConnection {
    /**
     * URLConnection set the HttpURLConnection for server connection with any api methords
     */

    public static String TAG = "URLConnection";

    /*Builder class can handle future api methods of push champ in one house*/

    public static class Builder {


        private String apiEvent;
        private String messageBody;


        public Builder() {

        }

        //Set the url need to send or recede  info from ot to server
        public URLConnection.Builder setApi(String apiEvent) {

            this.apiEvent = apiEvent;
            return this;

        }

        //Set the message body the request data to server
        public URLConnection.Builder setMessageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }


        //This build a HttpURLConnection which  need to connect with server
        public HttpURLConnection build() {

            HttpURLConnection conn = null;
            URL url;


            try {

                url = new URL(VersionInfo.BASE_URL + VersionInfo.SEPARATOR + VersionInfo.version + VersionInfo.SEPARATOR + apiEvent + VersionInfo.SEPARATOR);


//                Log.d(TAG,url.getPath());


                conn = (HttpURLConnection) url.openConnection();
                conn.setReadTimeout(VersionInfo.READ_TIMEOUT);
                conn.setConnectTimeout(VersionInfo.TIMEOUT);
                conn.setRequestMethod(VersionInfo.POST_METHORD);
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setInstanceFollowRedirects(false);
                conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                if (messageBody != null) {
                    conn.setFixedLengthStreamingMode(messageBody.getBytes().length);
                }

                conn.setUseCaches(false);

                if (messageBody != null) {
                    OutputStream os = new BufferedOutputStream(conn.getOutputStream());
                    os.write(messageBody.getBytes());

                    os.flush();
                    os.close();
                }
            } catch (MalformedURLException e) {
                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
            } catch (ProtocolException e) {
                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
            } catch (UnsupportedEncodingException e) {
                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
            } catch (UnknownHostException e) {
                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
            } catch (IOException e) {
                PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);
            }


            return conn;
        }


    }
}
