package com.pushchamp.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.util.Log;

import com.pushchamp.PushChamp;
import com.pushchamp.PushchampPreferences;
import com.pushchamp.PushchampSubscription;
import com.pushchamp.events.EventApiCall;

/**
 * Created by Ramesh on 26/12/16.
 */

public class PushChampNetworkChangeReceiver extends BroadcastReceiver {

    /**
     * BroadcastReceiver Triggered when a connection get established
     * This class help to Subscribe if user failed app launch first time due to network failure
     * Also it pass any pending events to server that failed to send due to network failure
     */

    public static String TAG = "PushChampNCR";

    @Override
    public void onReceive(final Context context, final Intent intent) {
        if (intent.getAction().equals(ConnectivityManager.CONNECTIVITY_ACTION)) {


          /*  NetworkInfo networkInfo =
                    intent.getParcelableExtra(ConnectivityManager.EXTRA_NETWORK_INFO);
            if(networkInfo.getType() == ConnectivityManager.TYPE_WIFI &&
                    ! networkInfo.isConnected()) {
                // Wifi is disconnected
                Log.d("Inetify", "Wifi is disconnected: " + String.valueOf(networkInfo));
            }*/

            if (new ConnectionDetector(context).isConnectingToInternet()) {

                try {
                    PushChamp.getLogger().d(TAG, "NETWORK CHANGED");

                    if (context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).getString(PushchampPreferences.SUBSCRIPTION_ID, null) != null) {

                        if (context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).getString(PushchampPreferences.SUBSCRIPTION_ID, null).length() > 1) {


                            PushChamp.getLogger().d(TAG, "Pending Event Transferring");

                            new EventApiCall().startEventCall(context, context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).getString(PushchampPreferences.SUBSCRIPTION_ID, null));

                        }
                    } else {

                        PushChamp.getLogger().d(TAG, "Not Subscribed yet Going to Subscribe");

                        PushchampSubscription ps = new PushchampSubscription(context);
                        ps.register();

                    }
                } catch (Exception e) {

                }


            }
        }


    }
}
