package com.pushchamp.events;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;

import com.pushchamp.PushChamp;
import com.pushchamp.PushchampPreferences;
import com.pushchamp.SharedPreferencesLoader;
import com.pushchamp.database.DatabaseHandler;
import com.pushchamp.database.EventsModel;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/**
 * Created by rajesh on 7/12/16.
 */

public class EventsApiGenerator {

    private final Context mContext;


    public EventsApiGenerator(Context context) {
        mContext = context;
    }



    @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
    /* package */ public void registerEventsActivityLifecycleCallbacks() {

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH) {
            if (mContext.getApplicationContext() instanceof Application) {

                SessionGenerator.getInstance().checkForSessionChange(mContext);

                final Application app = (Application) mContext.getApplicationContext();

                ActivityLifecycleHandler activityLifecycleHandler = new ActivityLifecycleHandler();
                app.registerActivityLifecycleCallbacks(activityLifecycleHandler);

            }
        }
    }



}
