package com.pushchamp.events;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;

import com.pushchamp.PushChamp;
import com.pushchamp.PushchampPreferences;
import com.pushchamp.database.DatabaseHandler;
import com.pushchamp.database.EventsModel;
import com.pushchamp.utils.ConnectionDetector;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.concurrent.TimeUnit;

/**
 * Created by rajesh on 6/12/16.
 */
@TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
public class ActivityLifecycleHandler implements Application.ActivityLifecycleCallbacks {

    Activity lifeCycleContext;

    long tsValueField,passingTs;

    JSONObject deviceJSON;
    JSONArray jsonArray;
    JSONObject emptyArray;

    String subscriptionId;
    String activityName;
    long tfsValueField;
    private String ssid;

    private ConnectionDetector mCheckconnection;

    private String appName;


    @Override
    public void onActivityCreated(Activity activity, Bundle bundle) {
        SharedPreferences sharedPreferences = activity.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE);

        activityName = activity.getComponentName().getShortClassName().substring(activity.getComponentName().getShortClassName().lastIndexOf(".") + 1).trim().toString();
        lifeCycleContext = activity;



        mCheckconnection = new ConnectionDetector(activity);


        deviceJSON = new JSONObject();
        jsonArray = new JSONArray();

        subscriptionId = lifeCycleContext.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).getString(PushchampPreferences.SUBSCRIPTION_ID, null);


        tsValueField = System.currentTimeMillis();



        tfsValueField = TimeUnit.MILLISECONDS.toSeconds((System.currentTimeMillis() - sharedPreferences.getLong("ts", 0)));


        emptyArray = new JSONObject();

        appName = PushchampPreferences.APP_NAME;

        if(appName.equals("")){
            ApplicationInfo ai = null;
            try {
                ai = lifeCycleContext.getPackageManager().getApplicationInfo(lifeCycleContext.getPackageName(), PackageManager.GET_META_DATA);
                appName = (String)ai.metaData.get("pushchamp_app_id");

            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        ssid = lifeCycleContext.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).getString(PushchampPreferences.SESSION_ID, "");

        passingTs = System.currentTimeMillis();


        DatabaseHandler databaseHandler = new DatabaseHandler(activity);
        databaseHandler.addEvent(new EventsModel(ssid,appName,activityName,PushchampPreferences.EVENT_TYPE,passingTs,tfsValueField,PushchampPreferences.PLATFORM, emptyArray.toString()));
        databaseHandler.close();


        if (mCheckconnection.isConnectingToInternet()){

            /*Check a subscriptionId has generated */

            if(!(subscriptionId == null)){
                if(subscriptionId.length()>0)
                {
                    new EventApiCall().startEventCall(lifeCycleContext, lifeCycleContext.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).getString(PushchampPreferences.SUBSCRIPTION_ID, null));
                }
            }
        }

    }


    @Override
    public void onActivityStarted(Activity activity) {
        lifeCycleContext = activity;
    }

    @Override
    public void onActivityResumed(Activity activity) {

        lifeCycleContext = activity;
        SessionGenerator.getInstance().checkForSessionChange(activity);

    }

    @Override
    public void onActivityPaused(Activity activity) {
        lifeCycleContext = activity;
           /*App destroyed Time is recorded for calculating the section diffrence*/

        activity.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).edit().putLong(PushchampPreferences.APP_STOP_TIME,System.currentTimeMillis()).commit();

    }

    @Override
    public void onActivityStopped(Activity activity) {
        lifeCycleContext = activity;

    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {

    }



}
