package com.pushchamp;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.pushchamp.events.EventsApiGenerator;
import com.pushchamp.utils.Constants;

import java.util.HashMap;


public class PushchampSubscription {
    private static final String TAG = PushchampSubscription.class.getSimpleName();
    private String app;
    private Context context;

    private SharedPreferences sharedPrefs;
    private static final String EMAIL_KEY = "email";
    private static final String MOBILE_KEY = "mobile";
    private static final String USERID_KEY = "unique_id";

    public PushchampSubscription(Context ctx){
        this.context = ctx;
        sharedPrefs = ctx.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE);

    }

    public PushchampSubscription(Context ctx, String app){
        this.context = ctx;
        this.app = app;
        sharedPrefs = ctx.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE);

    }

    /*Get the push champApp id and google sender id from application manifest for registration*/
    public void register(){
        ApplicationInfo ai = null;
        try {
            ai = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), PackageManager.GET_META_DATA);
            this.app = (String)ai.metaData.get("pushchamp_app_id");


            PushchampPreferences.APP_NAME = this.app;


            register((String)ai.metaData.get("google_sender_id"));


        } catch (PackageManager.NameNotFoundException e) {
            PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);

        } catch (Exception e) {
            PushChamp.getLogger().w(TAG, Constants.EXCEPTION_MESSAGE, e);

        }
    }

    public void register(String sender_id){

        long applicationStartTime = System.currentTimeMillis();

        sharedPrefs.edit().putLong(PushchampPreferences.APP_START_TIME,applicationStartTime).commit();

        if (this.context!=null && checkPlayServices()) {

            String subscription_id = sharedPrefs.getString(PushchampPreferences.SUBSCRIPTION_ID, "");
            if (subscription_id == null || subscription_id.equals("")){
//                Log.d("Tag", "subscription_id is null: Device not registered");

                Intent intent = new Intent(this.context, PushchampRegistrationService.class);
                intent.putExtra(PushchampPreferences.SENDER_ID, sender_id);
                intent.putExtra(PushchampPreferences.APP_ID, this.app);
                this.context.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).edit().putString(PushchampPreferences.PREF_SENDER_ID, sender_id).apply();
                this.context.startService(intent);



            }



        }
    }

    public void updateTags(HashMap<String, String> add_tags, String[] delete_tags){
        String subscription_id = sharedPrefs.getString(PushchampPreferences.SUBSCRIPTION_ID, "");
        if (subscription_id==null){
            PushChamp.getLogger().e(TAG, "Update tag failed: Device not registered");
            return;
        }
        PushchampWrapper pc = new PushchampWrapper(context, this.app, null, add_tags, delete_tags, null, null);
        pc.execute();
    }

    public void addEmail(String email){
        this.addTag(EMAIL_KEY, email);
    }

    public void addMobile(String mobile){
        this.addTag(MOBILE_KEY, mobile);
    }

    public void addUserID(String uid){
        this.addTag(USERID_KEY, uid);
    }

    public void deleteEmail(){
        this.deleteTag(EMAIL_KEY);
    }

    public void deleteMobile(){
        this.deleteTag(MOBILE_KEY);
    }

    public void deleteUserID(){
        this.deleteTag(USERID_KEY);
    }

    public void addTag(String key, String value){
        String subscription_id = sharedPrefs.getString(PushchampPreferences.SUBSCRIPTION_ID, "");
        if (subscription_id==null){
            PushChamp.getLogger().e(TAG, "Update tag failed: Device not registered");
            return;
        }
        HashMap<String, String> add_tags = new HashMap<String, String>();
        add_tags.put(key, value);
        PushchampWrapper pc = new PushchampWrapper(context, this.app, null, add_tags, null, null, null);
        pc.execute();
    }

    public void deleteTag(String key){
        String subscription_id = sharedPrefs.getString(PushchampPreferences.SUBSCRIPTION_ID, "");
        if (subscription_id==null){
            PushChamp.getLogger().e(TAG, "Update tag failed: Device not registered");
            return;
        }
        String[] delete_tags = {key};
        PushchampWrapper pc = new PushchampWrapper(context, this.app, null, null, delete_tags, null, null);
        pc.execute();
    }

    public void addGroups(String[] add_groups){
        String subscription_id = sharedPrefs.getString(PushchampPreferences.SUBSCRIPTION_ID, "");
        if (subscription_id==null){
            PushChamp.getLogger().e(TAG, "Add groups failed: Device not registered");
            return;
        }
        PushchampWrapper pc = new PushchampWrapper(context, this.app, null, null, null, add_groups, null);
        pc.execute();
    }

    public void deleteGroups(String[] delete_groups){
        String subscription_id = sharedPrefs.getString(PushchampPreferences.SUBSCRIPTION_ID, "");
        if (subscription_id==null){

            PushChamp.getLogger().e(TAG,"Delete groups failed: Device not registered");

            return;
        }
        PushchampWrapper pc = new PushchampWrapper(context, this.app, null, null, null, null, delete_groups);
        pc.execute();
    }


    private boolean checkPlayServices() {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int resultCode = apiAvailability.isGooglePlayServicesAvailable(this.context);
        if (resultCode != ConnectionResult.SUCCESS) {
            PushChamp.getLogger().i(TAG, "This device is not supported for GCM.");
            return false;
        }
        return true;
    }


}
