package com.pushchamp;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;

import com.google.android.gms.gcm.GoogleCloudMessaging;

import java.io.IOException;

public class PushchampActivity extends Activity {

    private static final String TAG = PushchampActivity.class.getSimpleName();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            String notification_id = getIntent().getStringExtra("nid");
            String event = getIntent().getStringExtra("event");
            String class_name = getIntent().getStringExtra("class_name");
            if(class_name!=null){
                Intent pi = new Intent(this, Class.forName(class_name));
                pi.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(pi);
            }
            String msgs[] = new String[2];
            msgs[0] = event;
            msgs[1] = notification_id;
            new SendUpstreamMsg().execute(msgs);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private class SendUpstreamMsg extends AsyncTask<String, Void, Void> {
        protected Void doInBackground(String... msgs) {
            try {
                Bundle data = new Bundle();
                data.putString("event", msgs[0]);
                String id = msgs[1];
                GoogleCloudMessaging.getInstance(PushchampActivity.this).send(
                        PushchampActivity.this.getSharedPreferences(PushchampPreferences.SHAREDPREF_LOC, Context.MODE_PRIVATE).
                                getString(PushchampPreferences.PREF_SENDER_ID, "") + "@gcm.googleapis.com", id, data);
            } catch (IOException e) {
                PushChamp.getLogger().e(TAG, "IO Error :" + e.getMessage());
            }catch (Exception e){
                PushChamp.getLogger().e(TAG, "Error :" + e.getMessage());
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void aVoid) {
            super.onPostExecute(aVoid);
            PushchampActivity.this.finish();
        }
    }
}
