/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.site.ModuleJavadocParsingUtil;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import java.nio.file.Path;
import java.util.Locale;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.module.xdoc.XdocSink;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="parent-module")
public class ParentModuleMacro
extends AbstractMacro {
    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        if (!(sink instanceof XdocSink)) {
            throw new MacroExecutionException("Expected Sink to be an XdocSink.");
        }
        String moduleName = (String)request.getParameter("moduleName");
        Object instance = SiteUtil.getModuleInstance(moduleName);
        Class<?> clss = instance.getClass();
        ParentModuleMacro.createParentModuleParagraph((XdocSink)sink, clss, moduleName);
    }

    private static void createParentModuleParagraph(XdocSink sink, Class<?> clss, String moduleName) throws MacroExecutionException {
        String parentModule = SiteUtil.getParentModule(clss);
        String linkToParentModule = ParentModuleMacro.getLinkToParentModule(parentModule, moduleName);
        sink.setInsertNewline(false);
        sink.paragraph();
        sink.setInsertNewline(true);
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_10);
        sink.link(linkToParentModule);
        sink.text(parentModule);
        sink.link_();
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_8);
        sink.paragraph_();
    }

    private static String getLinkToParentModule(String parentModule, String moduleName) throws MacroExecutionException {
        Path templatePath = SiteUtil.getTemplatePath(moduleName);
        if (templatePath == null) {
            throw new MacroExecutionException(String.format(Locale.ROOT, "Could not find template for %s", moduleName));
        }
        Path templatePathParent = templatePath.getParent();
        if (templatePathParent == null) {
            throw new MacroExecutionException("Failed to get parent path for " + String.valueOf(templatePath));
        }
        return templatePathParent.relativize(Path.of("src", "site/xdoc", "config.xml")).toString().replace(".xml", ".html").replace('\\', '/') + "#" + parentModule;
    }
}

