/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.site.ModuleJavadocParsingUtil;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="allCheckSummaries")
public class AllCheckSummaries
extends AbstractMacro {
    public static final int CAPACITY = 3000;
    private static final Pattern TAG_PATTERN = Pattern.compile("(?i)</?(?:p|div|span|strong|em)[^>]*>");
    private static final String WHITESPACE_REGEX = "\\s+";
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern AMP_PATTERN = Pattern.compile("&(?![a-zA-Z#0-9]+;)");
    private static final Pattern HREF_PATTERN = Pattern.compile("href\\s*=\\s*['\"]([^'\"]*)['\"]", 34);
    private static final String SRC = "src";
    private static final String CHECKS = "checks";
    private static final Path JAVA_CHECKS_ROOT = Path.of("src", "main", "java", "com", "puppycrawl", "tools", "checkstyle", "checks");
    private static final Path SITE_CHECKS_ROOT = Path.of("src", "site", "xdoc", "checks");
    private static final String XML_EXTENSION = ".xml";
    private static final String HTML_EXTENSION = ".html";
    private static final String TD_TAG = "<td>";
    private static final String TD_CLOSE_TAG = "</td>";
    private static final String MISC_PACKAGE = "misc";
    private static final String ANNOTATION_PACKAGE = "annotation";
    private static final String TABLE_CLOSE_TAG = "</table>";
    private static final String DIV_CLOSE_TAG = "</div>";
    private static final String SECTION_CLOSE_TAG = "</section>";
    private static final String DIV_WRAPPER_TAG = "<div class=\"wrapper\">";
    private static final String TABLE_OPEN_TAG = "<table>";
    private static final String ANCHOR_SEPARATOR = "#";
    private static final String FIRST_CAPTURE_GROUP = "$1";
    private static final int MAX_LINE_WIDTH_TOTAL = 100;
    private static final int INDENT_WIDTH = 14;
    private static final int MAX_CONTENT_WIDTH = 86;
    private static final String CLOSING_ANCHOR_TAG = "</a>";
    private static final Pattern CODE_SPACE_PATTERN = Pattern.compile("\\s+(" + "</a>".substring(0, 2) + "code>)");

    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        String packageFilter = (String)request.getParameter("package");
        Map<String, String> xmlHrefMap = AllCheckSummaries.buildXmlHtmlMap();
        TreeMap<String, CheckInfo> infos = new TreeMap<String, CheckInfo>();
        AllCheckSummaries.processCheckFiles(infos, xmlHrefMap, packageFilter);
        StringBuilder normalRows = new StringBuilder(4096);
        StringBuilder holderRows = new StringBuilder(512);
        AllCheckSummaries.buildTableRows(infos, normalRows, holderRows);
        sink.rawText(normalRows.toString());
        if (packageFilter == null && !holderRows.isEmpty()) {
            AllCheckSummaries.appendHolderSection(sink, holderRows);
        } else if (packageFilter != null && !holderRows.isEmpty()) {
            AllCheckSummaries.appendFilteredHolderSection(sink, holderRows, packageFilter);
        }
    }

    private static void processCheckFiles(Map<String, CheckInfo> infos, Map<String, String> xmlHrefMap, String packageFilter) throws MacroExecutionException {
        try {
            final ArrayList checkFiles = new ArrayList();
            Files.walkFileTree(JAVA_CHECKS_ROOT, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (AllCheckSummaries.isCheckOrHolderFile(file)) {
                        checkFiles.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            checkFiles.forEach(path -> AllCheckSummaries.processCheckFile(path, infos, xmlHrefMap, packageFilter));
        }
        catch (IOException | IllegalStateException exception) {
            throw new MacroExecutionException("Failed to discover checks", (Throwable)exception);
        }
    }

    private static boolean isCheckOrHolderFile(Path path) {
        Path fileName = path.getFileName();
        return fileName != null && (fileName.toString().endsWith("Check.java") || fileName.toString().endsWith("Holder.java")) && Files.isRegularFile(path, new LinkOption[0]);
    }

    private static boolean isHolder(String moduleName) {
        return moduleName.endsWith("Holder");
    }

    private static void processCheckFile(Path path, Map<String, CheckInfo> infos, Map<String, String> xmlHrefMap, String packageFilter) {
        try {
            String description;
            String moduleName = CommonUtil.getFileNameWithoutExtension(path.toString());
            DetailNode javadoc = SiteUtil.getModuleJavadoc(moduleName, path);
            if (javadoc != null && (description = AllCheckSummaries.getDescriptionIfPresent(javadoc)) != null) {
                description = AllCheckSummaries.sanitizeAnchorUrls(description);
                String[] moduleInfo = AllCheckSummaries.determineModuleInfo(path, moduleName);
                String packageName = moduleInfo[1];
                if (packageFilter == null || packageFilter.equals(packageName)) {
                    String simpleName = moduleInfo[0];
                    String summary = AllCheckSummaries.sanitizeAndFirstSentence(description);
                    String href = AllCheckSummaries.resolveHref(xmlHrefMap, packageName, simpleName, packageFilter);
                    infos.put(simpleName, new CheckInfo(simpleName, href, summary));
                }
            }
        }
        catch (MacroExecutionException exceptionThrown) {
            throw new IllegalArgumentException(exceptionThrown);
        }
    }

    private static String[] determineModuleInfo(Path path, String moduleName) {
        String packageName = AllCheckSummaries.extractCategoryFromJavaPath(path);
        if ("indentation".equals(packageName)) {
            packageName = MISC_PACKAGE;
        }
        if (AllCheckSummaries.isHolder(moduleName)) {
            packageName = ANNOTATION_PACKAGE;
        }
        String simpleName = AllCheckSummaries.isHolder(moduleName) ? moduleName : moduleName.substring(0, moduleName.length() - "Check".length());
        return new String[]{simpleName, packageName};
    }

    @Nullable
    private static String getDescriptionIfPresent(DetailNode javadoc) {
        String result = null;
        if (javadoc != null) {
            try {
                String desc;
                if (ModuleJavadocParsingUtil.getModuleSinceVersionTagStartNode(javadoc) != null && !(desc = ModuleJavadocParsingUtil.getModuleDescription(javadoc)).isEmpty()) {
                    result = desc;
                }
            }
            catch (IllegalStateException exception) {
                result = null;
            }
        }
        return result;
    }

    private static void buildTableRows(Map<String, CheckInfo> infos, StringBuilder normalRows, StringBuilder holderRows) {
        for (CheckInfo info : infos.values()) {
            String row = AllCheckSummaries.buildTableRow(info);
            if (AllCheckSummaries.isHolder(info.simpleName)) {
                holderRows.append(row);
                continue;
            }
            normalRows.append(row);
        }
        AllCheckSummaries.removeLeadingNewline(normalRows);
        AllCheckSummaries.removeLeadingNewline(holderRows);
    }

    private static String buildTableRow(CheckInfo info) {
        String ind10 = ModuleJavadocParsingUtil.INDENT_LEVEL_10;
        String ind12 = ModuleJavadocParsingUtil.INDENT_LEVEL_12;
        String ind14 = ModuleJavadocParsingUtil.INDENT_LEVEL_14;
        String ind16 = ModuleJavadocParsingUtil.INDENT_LEVEL_16;
        String cleanSummary = AllCheckSummaries.sanitizeAnchorUrls(info.summary);
        return ind10 + "<tr>" + ind12 + TD_TAG + ind14 + "<a href=\"" + info.link + "\">" + ind16 + info.simpleName + ind14 + CLOSING_ANCHOR_TAG + ind12 + TD_CLOSE_TAG + ind12 + TD_TAG + ind14 + AllCheckSummaries.wrapSummary(cleanSummary) + ind12 + TD_CLOSE_TAG + ind10 + "</tr>";
    }

    private static void removeLeadingNewline(StringBuilder builder) {
        while (!builder.isEmpty() && Character.isWhitespace(builder.charAt(0))) {
            builder.delete(0, 1);
        }
    }

    private static void appendHolderSection(Sink sink, StringBuilder holderRows) {
        String holderSection = ModuleJavadocParsingUtil.INDENT_LEVEL_8 + TABLE_CLOSE_TAG + ModuleJavadocParsingUtil.INDENT_LEVEL_6 + DIV_CLOSE_TAG + ModuleJavadocParsingUtil.INDENT_LEVEL_4 + SECTION_CLOSE_TAG + ModuleJavadocParsingUtil.INDENT_LEVEL_4 + "<section name=\"Holder Checks\">" + ModuleJavadocParsingUtil.INDENT_LEVEL_6 + "<p>" + ModuleJavadocParsingUtil.INDENT_LEVEL_8 + "These checks aren't normal checks and are usually" + ModuleJavadocParsingUtil.INDENT_LEVEL_8 + "associated with a specialized filter to gather" + ModuleJavadocParsingUtil.INDENT_LEVEL_8 + "information the filter can't get on its own." + ModuleJavadocParsingUtil.INDENT_LEVEL_6 + "</p>" + ModuleJavadocParsingUtil.INDENT_LEVEL_6 + DIV_WRAPPER_TAG + ModuleJavadocParsingUtil.INDENT_LEVEL_8 + TABLE_OPEN_TAG + ModuleJavadocParsingUtil.INDENT_LEVEL_10 + String.valueOf(holderRows);
        sink.rawText(holderSection);
    }

    private static void appendFilteredHolderSection(Sink sink, StringBuilder holderRows, String packageName) {
        String packageTitle = AllCheckSummaries.getPackageDisplayName(packageName);
        String holderSection = ModuleJavadocParsingUtil.INDENT_LEVEL_8 + TABLE_CLOSE_TAG + ModuleJavadocParsingUtil.INDENT_LEVEL_6 + DIV_CLOSE_TAG + ModuleJavadocParsingUtil.INDENT_LEVEL_4 + SECTION_CLOSE_TAG + ModuleJavadocParsingUtil.INDENT_LEVEL_4 + "<section name=\"" + packageTitle + " Holder Checks\">" + ModuleJavadocParsingUtil.INDENT_LEVEL_6 + DIV_WRAPPER_TAG + ModuleJavadocParsingUtil.INDENT_LEVEL_8 + TABLE_OPEN_TAG + ModuleJavadocParsingUtil.INDENT_LEVEL_10 + String.valueOf(holderRows);
        sink.rawText(holderSection);
    }

    private static String getPackageDisplayName(String packageName) {
        Object result = packageName == null || packageName.isEmpty() ? packageName : packageName.substring(0, 1).toUpperCase(Locale.ENGLISH) + packageName.substring(1);
        return result;
    }

    private static Map<String, String> buildXmlHtmlMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (Files.exists(SITE_CHECKS_ROOT, new LinkOption[0])) {
            try {
                final ArrayList xmlFiles = new ArrayList();
                Files.walkFileTree(SITE_CHECKS_ROOT, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (AllCheckSummaries.isValidXmlFile(file)) {
                            xmlFiles.add(file);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                xmlFiles.forEach(path -> AllCheckSummaries.addXmlHtmlMapping(path, map));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return map;
    }

    private static boolean isValidXmlFile(Path path) {
        Path fileName = path.getFileName();
        return fileName != null && !"index.xml".equalsIgnoreCase(fileName.toString()) && path.toString().endsWith(XML_EXTENSION) && Files.isRegularFile(path, new LinkOption[0]);
    }

    private static void addXmlHtmlMapping(Path path, Map<String, String> map) {
        Path fileName = path.getFileName();
        if (fileName != null) {
            String fileNameString = fileName.toString();
            int extensionLength = 4;
            String base = fileNameString.substring(0, fileNameString.length() - 4).toLowerCase(Locale.ROOT);
            Path relativePath = SITE_CHECKS_ROOT.relativize(path);
            String relativePathString = relativePath.toString();
            String rel = relativePathString.replace('\\', '/').replace(XML_EXTENSION, HTML_EXTENSION);
            map.put(base, "checks/" + rel);
        }
    }

    private static String resolveHref(Map<String, String> xmlMap, String category, String simpleName, @Nullable String packageFilter) {
        Object result;
        String lower = simpleName.toLowerCase(Locale.ROOT);
        String href = xmlMap.get(lower);
        if (href != null) {
            if (packageFilter == null) {
                result = href + ANCHOR_SEPARATOR + simpleName;
            } else {
                int lastSlash = href.lastIndexOf(47);
                String filename = lastSlash >= 0 ? href.substring(lastSlash + 1) : href;
                result = filename + ANCHOR_SEPARATOR + simpleName;
            }
        } else {
            result = packageFilter == null ? String.format(Locale.ROOT, "%s/%s/%s.html%s%s", CHECKS, category, lower, ANCHOR_SEPARATOR, simpleName) : String.format(Locale.ROOT, "%s.html%s%s", lower, ANCHOR_SEPARATOR, simpleName);
        }
        return result;
    }

    private static String extractCategoryFromJavaPath(Path javaPath) {
        Path rel = JAVA_CHECKS_ROOT.relativize(javaPath);
        Path parent = rel.getParent();
        String result = parent == null ? MISC_PACKAGE : parent.toString().replace('\\', '/');
        return result;
    }

    private static String sanitizeAnchorUrls(String html) {
        String result;
        if (html == null || html.isEmpty()) {
            result = html;
        } else {
            Matcher matcher = HREF_PATTERN.matcher(html);
            StringBuilder buffer = new StringBuilder(html.length());
            while (matcher.find()) {
                String originalUrl = matcher.group(1);
                String cleanedUrl = SPACE_PATTERN.matcher(originalUrl).replaceAll("");
                String replacement = "href=\"" + Matcher.quoteReplacement(cleanedUrl) + "\"";
                matcher.appendReplacement(buffer, replacement);
            }
            matcher.appendTail(buffer);
            result = buffer.toString();
        }
        return result;
    }

    private static String sanitizeAndFirstSentence(String html) {
        String result;
        if (html == null || html.isEmpty()) {
            result = "";
        } else {
            String cleaned = AllCheckSummaries.sanitizeAnchorUrls(html);
            cleaned = TAG_PATTERN.matcher(cleaned).replaceAll("");
            cleaned = SPACE_PATTERN.matcher(cleaned).replaceAll(" ").trim();
            cleaned = AMP_PATTERN.matcher(cleaned).replaceAll("&amp;");
            cleaned = CODE_SPACE_PATTERN.matcher(cleaned).replaceAll(FIRST_CAPTURE_GROUP);
            result = AllCheckSummaries.extractFirstSentence(cleaned);
        }
        return result;
    }

    private static String extractFirstSentence(String text) {
        String result = "";
        if (text != null && !text.isEmpty()) {
            int end = -1;
            for (int index = 0; index < text.length(); ++index) {
                if (text.charAt(index) != '.' || index != text.length() - 1 && !Character.isWhitespace(text.charAt(index + 1)) && text.charAt(index + 1) != '<') continue;
                end = index;
                break;
            }
            result = end == -1 ? text.trim() : text.substring(0, end + 1).trim();
        }
        return result;
    }

    private static String wrapSummary(String text) {
        String wrapped = "";
        if (text != null && !text.isEmpty()) {
            String sanitized = AllCheckSummaries.sanitizeAnchorUrls(text);
            String indent = ModuleJavadocParsingUtil.INDENT_LEVEL_14;
            String clean = sanitized.trim();
            StringBuilder result = new StringBuilder(3000);
            int cleanIndex = 0;
            int cleanLen = clean.length();
            while (cleanIndex < cleanLen) {
                int remainingChars = cleanLen - cleanIndex;
                if (remainingChars <= 86) {
                    result.append(indent).append(clean.substring(cleanIndex)).append('\n');
                    break;
                }
                int idealBreak = cleanIndex + 86;
                int actualBreak = AllCheckSummaries.calculateBreakPoint(clean, cleanIndex, idealBreak);
                result.append(indent).append(clean, cleanIndex, actualBreak);
                for (cleanIndex = actualBreak; cleanIndex < cleanLen && clean.charAt(cleanIndex) == ' '; ++cleanIndex) {
                }
            }
            wrapped = result.toString().trim();
        }
        return wrapped;
    }

    private static int calculateBreakPoint(String clean, int cleanIndex, int idealBreak) {
        int anchorStart;
        int anchorOpenEnd = (anchorStart = clean.indexOf("<a ", cleanIndex)) == -1 ? -1 : clean.indexOf(62, anchorStart);
        int actualBreak = AllCheckSummaries.shouldBreakAfterAnchorOpen(anchorStart, anchorOpenEnd, idealBreak) ? anchorOpenEnd + 1 : (AllCheckSummaries.shouldBreakAfterAnchorContent(anchorStart, anchorOpenEnd, idealBreak, clean) ? anchorOpenEnd + 1 : AllCheckSummaries.findSafeBreakPoint(clean, cleanIndex, idealBreak));
        return actualBreak;
    }

    private static boolean shouldBreakAfterAnchorOpen(int anchorStart, int anchorOpenEnd, int idealBreak) {
        return anchorStart != -1 && anchorStart < idealBreak && anchorOpenEnd != -1 && anchorOpenEnd >= idealBreak;
    }

    private static boolean shouldBreakAfterAnchorContent(int anchorStart, int anchorOpenEnd, int idealBreak, String clean) {
        int anchorCloseStart;
        boolean result = anchorStart != -1 && anchorStart < idealBreak && anchorOpenEnd != -1 && anchorOpenEnd < idealBreak ? (anchorCloseStart = clean.indexOf(CLOSING_ANCHOR_TAG, anchorOpenEnd)) != -1 && anchorCloseStart >= idealBreak : false;
        return result;
    }

    private static int findSafeBreakPoint(String text, int start, int idealBreak) {
        int lastSpace = text.lastIndexOf(32, idealBreak);
        int actualBreak = lastSpace > start && lastSpace >= start + 43 ? lastSpace : idealBreak;
        return actualBreak;
    }

    private static final class CheckInfo {
        private final String simpleName;
        private final String link;
        private final String summary;

        private CheckInfo(String simpleName, String link, String summary) {
            this.simpleName = simpleName;
            this.link = link;
            this.summary = summary;
        }
    }
}

