/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

@StatelessCheck
public class IllegalImportCheck
extends AbstractCheck {
    public static final String MSG_KEY = "import.illegal";
    private final List<Pattern> illegalPkgsRegexps = new ArrayList<Pattern>();
    private final List<Pattern> illegalClassesRegexps = new ArrayList<Pattern>();
    private final List<Pattern> illegalModulesRegexps = new ArrayList<Pattern>();
    private String[] illegalPkgs;
    private String[] illegalClasses;
    private String[] illegalModules;
    private boolean regexp;

    public IllegalImportCheck() {
        this.setIllegalPkgs("sun");
    }

    public final void setIllegalPkgs(String ... from) {
        this.illegalPkgs = (String[])from.clone();
        this.illegalPkgsRegexps.clear();
        for (String illegalPkg : this.illegalPkgs) {
            this.illegalPkgsRegexps.add(CommonUtil.createPattern("^" + illegalPkg + "\\..*"));
        }
    }

    public void setIllegalClasses(String ... from) {
        for (String illegalClass : this.illegalClasses = (String[])from.clone()) {
            this.illegalClassesRegexps.add(CommonUtil.createPattern(illegalClass));
        }
    }

    public void setIllegalModules(String ... from) {
        for (String illegalModule : this.illegalModules = (String[])from.clone()) {
            this.illegalModulesRegexps.add(CommonUtil.createPattern(illegalModule));
        }
    }

    public void setRegexp(boolean regexp) {
        this.regexp = regexp;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30, 152, 227};
    }

    @Override
    public void visitToken(DetailAST ast) {
        FullIdent imp = ast.getType() == 30 ? FullIdent.createFullIdentBelow(ast) : FullIdent.createFullIdent(ast.getFirstChild().getNextSibling());
        String importText = imp.getText();
        if (this.isIllegalImport(importText)) {
            this.log(ast, MSG_KEY, importText);
        }
    }

    private boolean isIllegalImportByRegularExpressions(String importText) {
        boolean result = false;
        for (Pattern pattern : this.illegalPkgsRegexps) {
            if (!pattern.matcher(importText).matches()) continue;
            result = true;
            break;
        }
        for (Pattern pattern : this.illegalClassesRegexps) {
            if (!pattern.matcher(importText).matches()) continue;
            result = true;
            break;
        }
        for (Pattern pattern : this.illegalModulesRegexps) {
            if (!pattern.matcher(importText).matches()) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isIllegalImportLiteral(String importText) {
        boolean result = false;
        for (String element : this.illegalPkgs) {
            if (!importText.startsWith(element + ".")) continue;
            result = true;
            break;
        }
        if (this.illegalClasses != null) {
            for (String element : this.illegalClasses) {
                if (!importText.equals(element)) continue;
                result = true;
                break;
            }
        }
        if (this.illegalModules != null) {
            for (String element : this.illegalModules) {
                if (!importText.equals(element)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isIllegalImport(String importText) {
        boolean result = this.regexp ? this.isIllegalImportByRegularExpressions(importText) : this.isIllegalImportLiteral(importText);
        return result;
    }
}

