/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

@FileStatefulCheck
public class UnnecessaryParenthesesCheck
extends AbstractCheck {
    public static final String MSG_IDENT = "unnecessary.paren.ident";
    public static final String MSG_ASSIGN = "unnecessary.paren.assign";
    public static final String MSG_EXPR = "unnecessary.paren.expr";
    public static final String MSG_LITERAL = "unnecessary.paren.literal";
    public static final String MSG_STRING = "unnecessary.paren.string";
    public static final String MSG_RETURN = "unnecessary.paren.return";
    public static final String MSG_LAMBDA = "unnecessary.paren.lambda";
    private static final Pattern NEWLINE = Pattern.compile("\\R");
    private static final String QUOTE = "\"";
    private static final int MAX_QUOTED_LENGTH = 25;
    private static final int[] LITERALS = new int[]{142, 140, 137, 141, 139, 135, 134, 133, 204};
    private static final int[] ASSIGNMENTS = new int[]{80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    private static final int[] CONDITIONAL_OPERATOR = new int[]{110, 111};
    private static final int[] RELATIONAL_OPERATOR = new int[]{121, 118, 117, 120, 119, 116, 115};
    private static final int[] UNARY_AND_POSTFIX = new int[]{31, 32, 129, 130, 132, 131, 25, 26};
    private static final int[] BITWISE_BINARY_OPERATORS = new int[]{113, 112, 114};
    private DetailAST parentToSkip;
    private int assignDepth;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{28, 58, 142, 140, 137, 141, 139, 135, 134, 133, 80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100, 181, 204, 111, 110, 121, 118, 117, 120, 119, 116, 115, 31, 32, 129, 130, 132, 131, 25, 26};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{28, 58, 142, 140, 137, 141, 139, 135, 134, 133, 80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100, 181, 204, 111, 110, 121, 118, 117, 120, 119, 116, 115, 31, 32, 129, 130, 132, 131, 25, 26, 113, 112, 114, 109};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST parent = ast.getParent();
        if (UnnecessaryParenthesesCheck.isLambdaSingleParameterSurrounded(ast)) {
            this.log(ast, MSG_LAMBDA, new Object[0]);
        } else if (ast.getType() == 109) {
            UnnecessaryParenthesesCheck.getParenthesesChildrenAroundQuestion(ast).forEach(unnecessaryChild -> this.log((DetailAST)unnecessaryChild, MSG_EXPR, new Object[0]));
        } else if (parent.getType() != 160) {
            int type = ast.getType();
            boolean surrounded = UnnecessaryParenthesesCheck.isSurrounded(ast);
            if (surrounded && type == 58) {
                this.parentToSkip = ast.getParent();
                this.log(ast, MSG_IDENT, ast.getText());
            } else if (surrounded && TokenUtil.isOfType(type, LITERALS)) {
                this.parentToSkip = ast.getParent();
                if (type == 139) {
                    this.log(ast, MSG_STRING, UnnecessaryParenthesesCheck.chopString(ast.getText()));
                } else if (type == 204) {
                    String logString = QUOTE + NEWLINE.matcher(ast.getFirstChild().getText()).replaceAll("\\\\n") + QUOTE;
                    this.log(ast, MSG_STRING, UnnecessaryParenthesesCheck.chopString(logString));
                } else {
                    this.log(ast, MSG_LITERAL, ast.getText());
                }
            } else if (TokenUtil.isOfType(type, ASSIGNMENTS)) {
                ++this.assignDepth;
                DetailAST last = ast.getLastChild();
                if (last.getType() == 77) {
                    this.log(ast, MSG_ASSIGN, new Object[0]);
                }
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        int type = ast.getType();
        DetailAST parent = ast.getParent();
        if (type != 80 || parent.getType() != 160) {
            if (type == 28) {
                this.checkExpression(ast);
            } else if (TokenUtil.isOfType(type, ASSIGNMENTS)) {
                --this.assignDepth;
            } else if (UnnecessaryParenthesesCheck.isSurrounded(ast) && UnnecessaryParenthesesCheck.unnecessaryParenAroundOperators(ast)) {
                this.log(ast.getPreviousSibling(), MSG_EXPR, new Object[0]);
            }
        }
    }

    private static boolean isSurrounded(DetailAST ast) {
        DetailAST prev = ast.getPreviousSibling();
        DetailAST parent = ast.getParent();
        boolean isPreviousSiblingLeftParenthesis = prev != null && prev.getType() == 76;
        boolean isMethodCallWithUnnecessaryParenthesis = parent.getType() == 27 && parent.getPreviousSibling() != null && parent.getPreviousSibling().getType() == 76;
        return isPreviousSiblingLeftParenthesis || isMethodCallWithUnnecessaryParenthesis;
    }

    private static boolean isExprSurrounded(DetailAST ast) {
        return ast.getFirstChild().getType() == 76;
    }

    private void checkExpression(DetailAST ast) {
        if (this.parentToSkip != ast && UnnecessaryParenthesesCheck.isExprSurrounded(ast)) {
            if (ast.getParent().getType() == 88) {
                this.log(ast, MSG_RETURN, new Object[0]);
            } else if (this.assignDepth >= 1) {
                this.log(ast, MSG_ASSIGN, new Object[0]);
            } else {
                this.log(ast, MSG_EXPR, new Object[0]);
            }
        }
    }

    private static boolean unnecessaryParenAroundOperators(DetailAST ast) {
        int type = ast.getType();
        boolean isConditionalOrRelational = TokenUtil.isOfType(type, CONDITIONAL_OPERATOR) || TokenUtil.isOfType(type, RELATIONAL_OPERATOR);
        boolean isBitwise = TokenUtil.isOfType(type, BITWISE_BINARY_OPERATORS);
        boolean hasUnnecessaryParentheses = isConditionalOrRelational ? UnnecessaryParenthesesCheck.checkConditionalOrRelationalOperator(ast) : (isBitwise ? UnnecessaryParenthesesCheck.checkBitwiseBinaryOperator(ast) : TokenUtil.isOfType(type, UNARY_AND_POSTFIX) && UnnecessaryParenthesesCheck.isBitWiseBinaryOrConditionalOrRelationalOperator(ast.getParent().getType()));
        return hasUnnecessaryParentheses;
    }

    private static boolean checkConditionalOrRelationalOperator(DetailAST ast) {
        int type = ast.getType();
        int parentType = ast.getParent().getType();
        boolean isParentEqualityOperator = TokenUtil.isOfType(parentType, 116, 115);
        boolean result = type == 110 ? !TokenUtil.isOfType(parentType, 111) && !TokenUtil.isOfType(parentType, BITWISE_BINARY_OPERATORS) : (type == 111 ? !TokenUtil.isOfType(parentType, BITWISE_BINARY_OPERATORS) : true);
        return result && !isParentEqualityOperator && UnnecessaryParenthesesCheck.isBitWiseBinaryOrConditionalOrRelationalOperator(parentType);
    }

    private static boolean checkBitwiseBinaryOperator(DetailAST ast) {
        int type = ast.getType();
        int parentType = ast.getParent().getType();
        boolean result = type == 112 ? !TokenUtil.isOfType(parentType, 114, 113) && !TokenUtil.isOfType(parentType, RELATIONAL_OPERATOR) : (type == 113 ? !TokenUtil.isOfType(parentType, 114) && !TokenUtil.isOfType(parentType, RELATIONAL_OPERATOR) : !TokenUtil.isOfType(parentType, RELATIONAL_OPERATOR));
        return result && UnnecessaryParenthesesCheck.isBitWiseBinaryOrConditionalOrRelationalOperator(parentType);
    }

    private static boolean isBitWiseBinaryOrConditionalOrRelationalOperator(int type) {
        return TokenUtil.isOfType(type, CONDITIONAL_OPERATOR) || TokenUtil.isOfType(type, RELATIONAL_OPERATOR) || TokenUtil.isOfType(type, BITWISE_BINARY_OPERATORS);
    }

    private static boolean isLambdaSingleParameterSurrounded(DetailAST ast) {
        DetailAST parameters;
        DetailAST firstChild = ast.getFirstChild();
        boolean result = false;
        if (TokenUtil.isOfType(firstChild, 76) && (parameters = firstChild.getNextSibling()).getChildCount(21) == 1 && !parameters.getFirstChild().findFirstToken(13).hasChildren()) {
            result = true;
        }
        return result;
    }

    private static List<DetailAST> getParenthesesChildrenAroundQuestion(DetailAST questionToken) {
        ArrayList<DetailAST> surroundedChildren = new ArrayList<DetailAST>();
        for (DetailAST directChild = questionToken.getFirstChild(); directChild != null; directChild = directChild.getNextSibling()) {
            if (directChild.getType() != 76 || TokenUtil.isOfType(directChild.getNextSibling(), LITERALS)) continue;
            surroundedChildren.add(directChild);
        }
        return Collections.unmodifiableList(surroundedChildren);
    }

    private static String chopString(String value) {
        Object result = value;
        if (value.length() > 25) {
            result = value.substring(0, 25) + "...\"";
        }
        return result;
    }
}

