/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.HashSet;
import java.util.Set;

@FileStatefulCheck
public class RedundantImportCheck
extends AbstractCheck {
    public static final String MSG_LANG = "import.lang";
    public static final String MSG_SAME = "import.same";
    public static final String MSG_DUPLICATE = "import.duplicate";
    private final Set<FullIdent> imports = new HashSet<FullIdent>();
    private final Set<FullIdent> staticAndModuleImports = new HashSet<FullIdent>();
    private String pkgName;

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.pkgName = null;
        this.imports.clear();
        this.staticAndModuleImports.clear();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30, 152, 16, 227};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 16) {
            this.pkgName = FullIdent.createFullIdent(ast.getLastChild().getPreviousSibling()).getText();
        } else if (ast.getType() == 30) {
            FullIdent imp = FullIdent.createFullIdentBelow(ast);
            String importText = imp.getText();
            if (RedundantImportCheck.isFromPackage(importText, "java.lang")) {
                this.log(ast, MSG_LANG, importText);
            } else if (this.pkgName != null && RedundantImportCheck.isFromPackage(importText, this.pkgName)) {
                this.log(ast, MSG_SAME, importText);
            }
            this.imports.stream().filter(full -> importText.equals(full.getText())).forEach(full -> this.log(ast, MSG_DUPLICATE, full.getLineNo(), importText));
            this.imports.add(imp);
        } else {
            DetailAST identNode = ast.getLastChild().getPreviousSibling();
            FullIdent importFullIdent = FullIdent.createFullIdent(identNode);
            String importText = importFullIdent.getText();
            this.staticAndModuleImports.stream().filter(existingImport -> importText.equals(existingImport.getText())).forEach(existingImport -> this.log(ast, MSG_DUPLICATE, existingImport.getLineNo(), importText));
            this.staticAndModuleImports.add(importFullIdent);
        }
    }

    private static boolean isFromPackage(String importName, String pkg) {
        int index = importName.lastIndexOf(46);
        String front = importName.substring(0, index);
        return pkg.equals(front);
    }
}

