/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.site.ModuleJavadocParsingUtil;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.nio.file.Path;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="description")
public class DescriptionMacro
extends AbstractMacro {
    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        Path modulePath = Path.of((String)request.getParameter("modulePath"), new String[0]);
        String moduleName = CommonUtil.getFileNameWithoutExtension(modulePath.toString());
        DetailNode moduleJavadoc = SiteUtil.getModuleJavadoc(moduleName, modulePath);
        if (moduleJavadoc == null) {
            throw new MacroExecutionException("Javadoc of module " + moduleName + " is not found.");
        }
        String moduleDescription = ModuleJavadocParsingUtil.getModuleDescription(moduleJavadoc);
        ModuleJavadocParsingUtil.writeOutJavadocPortion(moduleDescription, sink);
    }
}

