/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.gui.MainFrameModel;
import com.puppycrawl.tools.checkstyle.gui.TreeTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 7970053543351871890L;
    private static final String ICON = "icon.png";
    private final transient MainFrameModel model = new MainFrameModel();
    private final ReloadAction reloadAction = new ReloadAction();
    private JTextArea textArea;
    private JTextArea xpathTextArea;
    private TreeTable treeTable;

    public MainFrame() {
        this.createContent();
    }

    private void createContent() {
        this.setLayout(new BorderLayout());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(MainFrame.class.getResource(ICON)));
        this.textArea = new JTextArea(20, 15);
        this.textArea.setEditable(false);
        JScrollPane textAreaScrollPane = new JScrollPane(this.textArea);
        JPanel textAreaPanel = new JPanel();
        textAreaPanel.setLayout(new BorderLayout());
        textAreaPanel.add(textAreaScrollPane);
        textAreaPanel.add((Component)this.createButtonsPanel(), "Last");
        this.treeTable = new TreeTable(this.model.getParseTreeTableModel());
        this.treeTable.setEditor(this.textArea);
        this.treeTable.setLinePositionList(this.model.getLinesToPosition());
        JScrollPane treeTableScrollPane = new JScrollPane(this.treeTable);
        JSplitPane splitPane = new JSplitPane(1, treeTableScrollPane, textAreaPanel);
        this.add((Component)splitPane, "Center");
        splitPane.setResizeWeight(0.7);
        this.xpathTextArea = new JTextArea("Xpath", 7, 0);
        this.xpathTextArea.setName("xpathTextArea");
        this.xpathTextArea.setVisible(false);
        JPanel xpathAreaPanel = new JPanel();
        xpathAreaPanel.setLayout(new BorderLayout());
        xpathAreaPanel.add(this.xpathTextArea);
        xpathAreaPanel.add((Component)this.createXpathButtonsPanel(), "Last");
        this.treeTable.setXpathEditor(this.xpathTextArea);
        TitledBorder title = BorderFactory.createTitledBorder("Xpath Query");
        xpathAreaPanel.setBorder(title);
        this.add((Component)xpathAreaPanel, "Last");
    }

    private JPanel createButtonsPanel() {
        JButton openFileButton = new JButton(new FileSelectionAction());
        openFileButton.setName("openFileButton");
        openFileButton.setMnemonic(79);
        openFileButton.setText("Open File");
        this.reloadAction.setEnabled(false);
        JButton reloadFileButton = new JButton(this.reloadAction);
        reloadFileButton.setMnemonic(82);
        reloadFileButton.setText("Reload File");
        JComboBox<MainFrameModel.ParseMode> modesCombobox = new JComboBox<MainFrameModel.ParseMode>(MainFrameModel.ParseMode.values());
        modesCombobox.setName("modesCombobox");
        modesCombobox.setSelectedIndex(0);
        modesCombobox.addActionListener(event -> {
            this.model.setParseMode((MainFrameModel.ParseMode)((Object)((Object)modesCombobox.getSelectedItem())));
            this.reloadAction.actionPerformed(null);
        });
        JLabel modesLabel = new JLabel("Modes:", 4);
        int leftIndentation = 10;
        modesLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        modesLabel.setDisplayedMnemonic(77);
        modesLabel.setLabelFor(modesCombobox);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(openFileButton);
        buttonPanel.add(reloadFileButton);
        JPanel modesPanel = new JPanel();
        modesPanel.add(modesLabel);
        modesPanel.add(modesCombobox);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add(buttonPanel);
        mainPanel.add((Component)modesPanel, "After");
        return mainPanel;
    }

    private JPanel createXpathButtonsPanel() {
        JButton expandButton = new JButton(new ExpandCollapseAction());
        expandButton.setName("expandButton");
        expandButton.setText("Expand/Collapse");
        JButton findNodeButton = new JButton(new FindNodeByXpathAction());
        findNodeButton.setName("findNodeButton");
        findNodeButton.setText("Find node by Xpath");
        JPanel xpathButtonsPanel = new JPanel();
        xpathButtonsPanel.setLayout(new FlowLayout());
        xpathButtonsPanel.add(expandButton);
        xpathButtonsPanel.add(findNodeButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)xpathButtonsPanel, "Before");
        return mainPanel;
    }

    public void openFile(File sourceFile) {
        try {
            this.model.openFile(sourceFile);
            this.setTitle(this.model.getTitle());
            this.reloadAction.setEnabled(this.model.isReloadActionEnabled());
            this.textArea.setText(this.model.getText());
            this.treeTable.setLinePositionList(this.model.getLinesToPosition());
        }
        catch (CheckstyleException exc) {
            JOptionPane.showMessageDialog(this, exc.getMessage());
        }
    }

    private final class ReloadAction
    extends AbstractAction {
        private static final long serialVersionUID = -890320994114628011L;

        private ReloadAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MainFrame.this.openFile(MainFrame.this.model.getCurrentFile());
        }
    }

    private final class FileSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1762396148873280589L;

        private FileSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JFileChooser fileChooser = new JFileChooser(MainFrame.this.model.getLastDirectory());
            JavaFileFilter filter = new JavaFileFilter();
            fileChooser.setFileFilter(filter);
            int returnCode = fileChooser.showOpenDialog(MainFrame.this);
            if (returnCode == 0) {
                File file = fileChooser.getSelectedFile();
                MainFrame.this.openFile(file);
            }
        }
    }

    private final class ExpandCollapseAction
    extends AbstractAction {
        private static final long serialVersionUID = -890320994114628011L;

        private ExpandCollapseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MainFrame.this.xpathTextArea.setVisible(!MainFrame.this.xpathTextArea.isVisible());
        }
    }

    private final class FindNodeByXpathAction
    extends AbstractAction {
        private static final long serialVersionUID = -890320994114628011L;

        private FindNodeByXpathAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MainFrame.this.treeTable.selectNodeByXpath();
        }
    }

    private static final class JavaFileFilter
    extends FileFilter {
        private JavaFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return MainFrameModel.shouldAcceptFile(file);
        }

        @Override
        public String getDescription() {
            return "Java Source File";
        }
    }
}

