/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.ArrayList;
import java.util.List;

@StatelessCheck
public class JavadocTagContinuationIndentationCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "tag.continuation.indent";
    private static final int DEFAULT_INDENTATION = 4;
    private static final String PRE_TAG = "pre";
    private int offset = 4;

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{68, 64};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (JavadocTagContinuationIndentationCheck.isBlockDescription(ast) && !JavadocTagContinuationIndentationCheck.isInlineDescription(ast)) {
            List<DetailNode> textNodes = JavadocTagContinuationIndentationCheck.getTargetedTextNodes(ast);
            for (DetailNode textNode : textNodes) {
                if (!this.isViolation(textNode)) continue;
                this.log(textNode.getLineNumber(), MSG_KEY, this.offset);
            }
        }
    }

    private static List<DetailNode> getTargetedTextNodes(DetailNode ast) {
        List<DetailNode> textNodes = ast.getType() == 64 ? JavadocTagContinuationIndentationCheck.getTargetedTextNodesInsideDescription(ast) : JavadocTagContinuationIndentationCheck.getTargetedTextNodesInsideHtmlElement(ast);
        return textNodes;
    }

    private static List<DetailNode> getTargetedTextNodesInsideHtmlElement(DetailNode ast) {
        ArrayList<DetailNode> textNodes = new ArrayList<DetailNode>();
        if (!JavadocUtil.isTag(ast, PRE_TAG) && !JavadocTagContinuationIndentationCheck.isInsidePreTag(ast)) {
            for (DetailNode node = ast.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getType() == 70) {
                    textNodes.addAll(JavadocTagContinuationIndentationCheck.getTargetedTextNodesInsideDescription(node));
                    continue;
                }
                if (JavadocTagContinuationIndentationCheck.subtreeContainsAttributeValue(node)) {
                    textNodes.addAll(JavadocTagContinuationIndentationCheck.getTargetedTextNodesInsideHtmlElement(node));
                    continue;
                }
                if (!JavadocTagContinuationIndentationCheck.isTargetTextNode(node)) continue;
                textNodes.add(node);
            }
        }
        return textNodes;
    }

    private static boolean subtreeContainsAttributeValue(DetailNode node) {
        return node.getType() == 71 || node.getType() == 73 || node.getType() == 74;
    }

    private static List<DetailNode> getTargetedTextNodesInsideDescription(DetailNode descriptionNode) {
        ArrayList<DetailNode> textNodes = new ArrayList<DetailNode>();
        DetailNode node = descriptionNode.getFirstChild();
        DetailNode previousSibling = descriptionNode.getPreviousSibling();
        if (JavadocTagContinuationIndentationCheck.isTargetTextNode(previousSibling)) {
            textNodes.add(previousSibling);
        }
        if (descriptionNode.getPreviousSibling().getType() == 2) {
            textNodes.add(node);
        }
        while (node != null) {
            if (JavadocTagContinuationIndentationCheck.isTargetTextNode(node)) {
                textNodes.add(node);
            }
            node = node.getNextSibling();
        }
        return textNodes;
    }

    private static boolean isTargetTextNode(DetailNode node) {
        DetailNode previousSibling = node.getPreviousSibling();
        return previousSibling != null && JavadocTagContinuationIndentationCheck.isTextOrAttributeValueNode(node) && !JavadocTagContinuationIndentationCheck.isBeforePreTag(node) && previousSibling.getType() == 2;
    }

    private static boolean isBeforePreTag(DetailNode node) {
        DetailNode nextSibling = node.getNextSibling();
        boolean isBeforePreTag = nextSibling != null && nextSibling.getType() == 64 ? JavadocUtil.isTag(nextSibling.getFirstChild(), PRE_TAG) : (nextSibling != null ? JavadocUtil.isTag(nextSibling, PRE_TAG) : false);
        return isBeforePreTag;
    }

    private static boolean isInsidePreTag(DetailNode node) {
        DetailNode htmlElementParent = node.getParent().getParent();
        return JavadocUtil.isTag(htmlElementParent, PRE_TAG);
    }

    private static boolean isTextOrAttributeValueNode(DetailNode node) {
        return node.getType() == 4 || node.getType() == 27;
    }

    private boolean isViolation(DetailNode textNode) {
        boolean result = false;
        String text = textNode.getText();
        if (text.length() <= this.offset) {
            if (CommonUtil.isBlank(text)) {
                DetailNode nextNode = textNode.getNextSibling();
                if (nextNode.getType() != 3) {
                    result = true;
                }
            } else {
                result = true;
            }
        } else if (!CommonUtil.isBlank(text.substring(1, this.offset + 1))) {
            result = true;
        }
        return result;
    }

    private static boolean isBlockDescription(DetailNode description) {
        boolean isBlock = false;
        for (DetailNode currentNode = description; currentNode != null; currentNode = currentNode.getParent()) {
            if (currentNode.getType() != 75) continue;
            isBlock = true;
            break;
        }
        return isBlock;
    }

    private static boolean isInlineDescription(DetailNode description) {
        boolean isInline = false;
        for (DetailNode currentNode = description; currentNode != null; currentNode = currentNode.getParent()) {
            if (currentNode.getType() != 6) continue;
            isInline = true;
            break;
        }
        return isInline;
    }
}

