/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.PropertyCacheFile;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.XdocsPropertyType;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.BeforeExecutionFileFilter;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifierOption;
import com.puppycrawl.tools.checkstyle.checks.regexp.RegexpMultilineCheck;
import com.puppycrawl.tools.checkstyle.checks.regexp.RegexpSinglelineCheck;
import com.puppycrawl.tools.checkstyle.checks.regexp.RegexpSinglelineJavaCheck;
import com.puppycrawl.tools.checkstyle.site.ClassAndPropertiesSettersJavadocScraper;
import com.puppycrawl.tools.checkstyle.site.JavadocScraperResultUtil;
import com.puppycrawl.tools.checkstyle.site.ViolationMessagesMacro;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.maven.doxia.macro.MacroExecutionException;

public final class SiteUtil {
    public static final String TOKENS = "tokens";
    public static final String JAVADOC_TOKENS = "javadocTokens";
    public static final String DOT = ".";
    public static final String COMMA_SPACE = ", ";
    public static final String TOKEN_TYPES = "TokenTypes";
    public static final String PATH_TO_TOKEN_TYPES = "apidocs/com/puppycrawl/tools/checkstyle/api/TokenTypes.html";
    public static final String PATH_TO_JAVADOC_TOKEN_TYPES = "apidocs/com/puppycrawl/tools/checkstyle/api/JavadocTokenTypes.html";
    public static final String SINCE_VERSION = "Since version";
    private static final String CHECKSTYLE_ORG_URL = "https://checkstyle.org/";
    private static final String CHARSET = "charset";
    private static final String CURLY_BRACKETS = "{}";
    private static final String FILE_EXTENSIONS = "fileExtensions";
    private static final String CHECKS = "checks";
    private static final String NAMING = "naming";
    private static final String SRC = "src";
    private static final String WHITESPACE = " ";
    private static final Pattern SETTER_PATTERN = Pattern.compile("^Setter to ");
    private static final Map<Class<?>, String> CLASS_TO_PARENT_MODULE = Map.ofEntries(Map.entry(AbstractCheck.class, TreeWalker.class.getSimpleName()), Map.entry(TreeWalkerFilter.class, TreeWalker.class.getSimpleName()), Map.entry(AbstractFileSetCheck.class, Checker.class.getSimpleName()), Map.entry(Filter.class, Checker.class.getSimpleName()), Map.entry(BeforeExecutionFileFilter.class, Checker.class.getSimpleName()));
    private static final Set<String> CHECK_PROPERTIES = SiteUtil.getProperties(AbstractCheck.class);
    private static final Set<String> JAVADOC_CHECK_PROPERTIES = SiteUtil.getProperties(AbstractJavadocCheck.class);
    private static final Set<String> FILESET_PROPERTIES = SiteUtil.getProperties(AbstractFileSetCheck.class);
    private static final String HEADER_CHECK_HEADER = "HeaderCheck.header";
    private static final String REGEXP_HEADER_CHECK_HEADER = "RegexpHeaderCheck.header";
    private static final Set<String> UNDOCUMENTED_PROPERTIES = Set.of("SuppressWithNearbyCommentFilter.fileContents", "SuppressionCommentFilter.fileContents");
    private static final Set<String> PROPERTIES_ALLOWED_GET_TYPES_FROM_METHOD = Set.of("SuppressWarningsHolder.aliasList", "HeaderCheck.header", "RegexpHeaderCheck.header", "RedundantModifierCheck.jdkVersion", "CustomImportOrderCheck.customImportOrderRules");
    private static final Map<String, DetailNode> SUPER_CLASS_PROPERTIES_JAVADOCS = new HashMap<String, DetailNode>();
    private static final String MAIN_FOLDER_PATH = Path.of("src", "main", "java", "com", "puppycrawl", "tools", "checkstyle").toString();
    private static final List<Path> MODULE_SUPER_CLASS_PATHS = List.of(Path.of(MAIN_FOLDER_PATH, "checks", "naming", "AbstractAccessControlNameCheck.java"), Path.of(MAIN_FOLDER_PATH, "checks", "naming", "AbstractNameCheck.java"), Path.of(MAIN_FOLDER_PATH, "checks", "javadoc", "AbstractJavadocCheck.java"), Path.of(MAIN_FOLDER_PATH, "api", "AbstractFileSetCheck.java"), Path.of(MAIN_FOLDER_PATH, "checks", "header", "AbstractHeaderCheck.java"), Path.of(MAIN_FOLDER_PATH, "checks", "metrics", "AbstractClassCouplingCheck.java"), Path.of(MAIN_FOLDER_PATH, "checks", "whitespace", "AbstractParenPadCheck.java"));

    private SiteUtil() {
    }

    public static Set<String> getMessageKeys(Class<?> module) throws MacroExecutionException {
        Set<Field> messageKeyFields = SiteUtil.getCheckMessageKeys(module);
        TreeSet<String> messageKeys = new TreeSet<String>();
        for (Field field : messageKeyFields) {
            messageKeys.add(SiteUtil.getFieldValue(field, module).toString());
        }
        return messageKeys;
    }

    private static Set<Field> getCheckMessageKeys(Class<?> module) throws MacroExecutionException {
        try {
            Field[] fields;
            HashSet<Field> checkstyleMessages = new HashSet<Field>();
            for (Field field : fields = module.getDeclaredFields()) {
                if (!field.getName().startsWith("MSG_")) continue;
                checkstyleMessages.add(field);
            }
            Class<?> superModule = module.getSuperclass();
            if (superModule != null) {
                checkstyleMessages.addAll(SiteUtil.getCheckMessageKeys(superModule));
            }
            if (module == RegexpMultilineCheck.class) {
                checkstyleMessages.addAll(SiteUtil.getCheckMessageKeys(Class.forName("com.puppycrawl.tools.checkstyle.checks.regexp.MultilineDetector")));
            } else if (module == RegexpSinglelineCheck.class || module == RegexpSinglelineJavaCheck.class) {
                checkstyleMessages.addAll(SiteUtil.getCheckMessageKeys(Class.forName("com.puppycrawl.tools.checkstyle.checks.regexp.SinglelineDetector")));
            }
            return checkstyleMessages;
        }
        catch (ClassNotFoundException exc) {
            String message = String.format(Locale.ROOT, "Couldn't find class: %s", module.getName());
            throw new MacroExecutionException(message, (Throwable)exc);
        }
    }

    public static Object getFieldValue(Field field, Object instance) throws MacroExecutionException {
        try {
            field.trySetAccessible();
            return field.get(instance);
        }
        catch (IllegalAccessException exc) {
            throw new MacroExecutionException("Couldn't get field value", (Throwable)exc);
        }
    }

    public static Object getModuleInstance(String moduleName) throws MacroExecutionException {
        PackageObjectFactory factory = SiteUtil.getPackageObjectFactory();
        try {
            return factory.createModule(moduleName);
        }
        catch (CheckstyleException exc) {
            throw new MacroExecutionException("Couldn't find class: " + moduleName, (Throwable)exc);
        }
    }

    private static PackageObjectFactory getPackageObjectFactory() throws MacroExecutionException {
        try {
            ClassLoader cl = ViolationMessagesMacro.class.getClassLoader();
            Set<String> packageNames = PackageNamesLoader.getPackageNames(cl);
            return new PackageObjectFactory(packageNames, cl);
        }
        catch (CheckstyleException exc) {
            throw new MacroExecutionException("Couldn't load checkstyle modules", (Throwable)exc);
        }
    }

    public static String getNewlineAndIndentSpaces(int amountOfSpaces) {
        return System.lineSeparator() + WHITESPACE.repeat(amountOfSpaces);
    }

    public static Path getTemplatePath(String moduleName) throws MacroExecutionException {
        String fileNamePattern = ".*[\\\\/]" + moduleName.toLowerCase(Locale.ROOT) + "\\..*";
        return SiteUtil.getXdocsTemplatesFilePaths().stream().filter(path -> path.toString().matches(fileNamePattern)).findFirst().orElse(null);
    }

    public static Set<Path> getXdocsTemplatesFilePaths() throws MacroExecutionException {
        Set<Path> set;
        block8: {
            Path directory = Path.of("src/site/xdoc", new String[0]);
            Stream<Path> stream = Files.find(directory, Integer.MAX_VALUE, (path, attr) -> attr.isRegularFile() && path.toString().endsWith(".xml.template"), new FileVisitOption[0]);
            try {
                set = stream.collect(Collectors.toUnmodifiableSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    throw new MacroExecutionException("Failed to find xdocs templates", (Throwable)ioException);
                }
            }
            stream.close();
        }
        return set;
    }

    public static String getParentModule(Class<?> moduleClass) throws MacroExecutionException {
        String parentModuleName = "";
        for (Class<?> parentClass = moduleClass.getSuperclass(); parentClass != null && (parentModuleName = CLASS_TO_PARENT_MODULE.get(parentClass)) == null; parentClass = parentClass.getSuperclass()) {
        }
        if (parentModuleName == null || parentModuleName.isEmpty()) {
            Class<?> interfaceClass;
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = moduleClass.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (parentModuleName = CLASS_TO_PARENT_MODULE.get(interfaceClass = classArray[i])) == null; ++i) {
            }
        }
        if (parentModuleName == null || parentModuleName.isEmpty()) {
            String message = String.format(Locale.ROOT, "Failed to find parent module for %s", moduleClass.getSimpleName());
            throw new MacroExecutionException(message);
        }
        return parentModuleName;
    }

    public static Set<String> getPropertiesForDocumentation(Class<?> clss, Object instance) {
        Set properties = SiteUtil.getProperties(clss).stream().filter(prop -> !SiteUtil.isGlobalProperty(clss, prop) && !SiteUtil.isUndocumentedProperty(clss, prop)).collect(Collectors.toCollection(HashSet::new));
        properties.addAll(SiteUtil.getNonExplicitProperties(instance, clss));
        return new TreeSet<String>(properties);
    }

    public static DetailNode getModuleJavadoc(String moduleName, Path modulePath) throws MacroExecutionException {
        SiteUtil.processModule(moduleName, modulePath);
        return JavadocScraperResultUtil.getModuleJavadocNode();
    }

    public static Map<String, DetailNode> getPropertiesJavadocs(Set<String> properties, String moduleName, Path modulePath) throws MacroExecutionException {
        if (SUPER_CLASS_PROPERTIES_JAVADOCS.isEmpty()) {
            SiteUtil.processSuperclasses();
        }
        SiteUtil.processModule(moduleName, modulePath);
        Map<String, DetailNode> unmodifiablePropertiesJavadocs = JavadocScraperResultUtil.getPropertiesJavadocNode();
        LinkedHashMap<String, DetailNode> propertiesJavadocs = new LinkedHashMap<String, DetailNode>(unmodifiablePropertiesJavadocs);
        properties.forEach(property -> {
            DetailNode superClassPropertyJavadoc = SUPER_CLASS_PROPERTIES_JAVADOCS.get(property);
            if (superClassPropertyJavadoc != null) {
                propertiesJavadocs.putIfAbsent((String)property, superClassPropertyJavadoc);
            }
        });
        SiteUtil.assertAllPropertySetterJavadocsAreFound(properties, moduleName, propertiesJavadocs);
        return propertiesJavadocs;
    }

    private static void assertAllPropertySetterJavadocsAreFound(Set<String> properties, String moduleName, Map<String, DetailNode> javadocs) throws MacroExecutionException {
        for (String property : properties) {
            boolean isDocumented = javadocs.containsKey(property) || SUPER_CLASS_PROPERTIES_JAVADOCS.containsKey(property) || TOKENS.equals(property) || JAVADOC_TOKENS.equals(property);
            if (isDocumented) continue;
            throw new MacroExecutionException(String.format(Locale.ROOT, "%s: Missing documentation for property '%s'. Check superclasses.", moduleName, property));
        }
    }

    private static void processSuperclasses() throws MacroExecutionException {
        for (Path superclassPath : MODULE_SUPER_CLASS_PATHS) {
            Path fileNamePath = superclassPath.getFileName();
            if (fileNamePath == null) {
                throw new MacroExecutionException("Invalid superclass path: " + String.valueOf(superclassPath));
            }
            String superclassName = CommonUtil.getFileNameWithoutExtension(fileNamePath.toString());
            SiteUtil.processModule(superclassName, superclassPath);
            Map<String, DetailNode> superclassPropertiesJavadocs = JavadocScraperResultUtil.getPropertiesJavadocNode();
            SUPER_CLASS_PROPERTIES_JAVADOCS.putAll(superclassPropertiesJavadocs);
        }
    }

    private static void processModule(String moduleName, Path modulePath) throws MacroExecutionException {
        if (!Files.isRegularFile(modulePath, new LinkOption[0])) {
            String message = String.format(Locale.ROOT, "File %s is not a file. Please check the 'modulePath' property.", modulePath);
            throw new MacroExecutionException(message);
        }
        ClassAndPropertiesSettersJavadocScraper.initialize(moduleName);
        Checker checker = new Checker();
        checker.setModuleClassLoader(Checker.class.getClassLoader());
        DefaultConfiguration scraperCheckConfig = new DefaultConfiguration(ClassAndPropertiesSettersJavadocScraper.class.getName());
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration("configuration");
        DefaultConfiguration treeWalkerConfig = new DefaultConfiguration(TreeWalker.class.getName());
        defaultConfiguration.addProperty(CHARSET, StandardCharsets.UTF_8.name());
        defaultConfiguration.addChild(treeWalkerConfig);
        treeWalkerConfig.addChild(scraperCheckConfig);
        try {
            checker.configure(defaultConfiguration);
            List<File> filesToProcess = List.of(modulePath.toFile());
            checker.process(filesToProcess);
            checker.destroy();
        }
        catch (CheckstyleException checkstyleException) {
            String message = String.format(Locale.ROOT, "Failed processing %s", moduleName);
            throw new MacroExecutionException(message, (Throwable)checkstyleException);
        }
    }

    public static Set<String> getProperties(Class<?> clss) {
        PropertyDescriptor[] propertyDescriptors;
        TreeSet<String> result = new TreeSet<String>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(clss)) {
            if (propertyDescriptor.getWriteMethod() == null) continue;
            result.add(propertyDescriptor.getName());
        }
        return result;
    }

    private static boolean isGlobalProperty(Class<?> clss, String propertyName) {
        return AbstractCheck.class.isAssignableFrom(clss) && CHECK_PROPERTIES.contains(propertyName) || AbstractJavadocCheck.class.isAssignableFrom(clss) && JAVADOC_CHECK_PROPERTIES.contains(propertyName) || AbstractFileSetCheck.class.isAssignableFrom(clss) && FILESET_PROPERTIES.contains(propertyName);
    }

    private static boolean isUndocumentedProperty(Class<?> clss, String propertyName) {
        return UNDOCUMENTED_PROPERTIES.contains(clss.getSimpleName() + DOT + propertyName);
    }

    private static Set<String> getNonExplicitProperties(Object instance, Class<?> clss) {
        AbstractCheck check;
        TreeSet<String> result = new TreeSet<String>();
        if (AbstractCheck.class.isAssignableFrom(clss)) {
            check = (AbstractCheck)instance;
            int[] acceptableTokens = check.getAcceptableTokens();
            Arrays.sort(acceptableTokens);
            int[] defaultTokens = check.getDefaultTokens();
            Arrays.sort(defaultTokens);
            int[] requiredTokens = check.getRequiredTokens();
            Arrays.sort(requiredTokens);
            if (!Arrays.equals(acceptableTokens, defaultTokens) || !Arrays.equals(acceptableTokens, requiredTokens)) {
                result.add(TOKENS);
            }
        }
        if (AbstractJavadocCheck.class.isAssignableFrom(clss)) {
            check = (AbstractJavadocCheck)instance;
            result.add("violateExecutionOnNonTightHtml");
            int[] acceptableJavadocTokens = ((AbstractJavadocCheck)check).getAcceptableJavadocTokens();
            Arrays.sort(acceptableJavadocTokens);
            int[] defaultJavadocTokens = ((AbstractJavadocCheck)check).getDefaultJavadocTokens();
            Arrays.sort(defaultJavadocTokens);
            int[] requiredJavadocTokens = ((AbstractJavadocCheck)check).getRequiredJavadocTokens();
            Arrays.sort(requiredJavadocTokens);
            if (!Arrays.equals(acceptableJavadocTokens, defaultJavadocTokens) || !Arrays.equals(acceptableJavadocTokens, requiredJavadocTokens)) {
                result.add(JAVADOC_TOKENS);
            }
        }
        if (AbstractFileSetCheck.class.isAssignableFrom(clss)) {
            result.add(FILE_EXTENSIONS);
        }
        return result;
    }

    public static String getPropertyDescription(String propertyName, DetailNode javadoc, String moduleName) throws MacroExecutionException {
        Object description;
        if (TOKENS.equals(propertyName)) {
            description = "tokens to check";
        } else if (JAVADOC_TOKENS.equals(propertyName)) {
            description = "javadoc tokens to check";
        } else {
            String descriptionString = SETTER_PATTERN.matcher(DescriptionExtractor.getDescriptionFromJavadoc(javadoc, moduleName)).replaceFirst("");
            String firstLetterCapitalized = descriptionString.substring(0, 1).toUpperCase(Locale.ROOT);
            description = firstLetterCapitalized + descriptionString.substring(1);
        }
        return description;
    }

    public static String getPropertySinceVersion(String moduleName, DetailNode moduleJavadoc, String propertyName, DetailNode propertyJavadoc) throws MacroExecutionException {
        String sinceVersion;
        Optional<String> specifiedPropertyVersionInModule = SiteUtil.getSpecifiedPropertyVersionInModule(propertyName, moduleJavadoc);
        if (specifiedPropertyVersionInModule.isPresent()) {
            sinceVersion = specifiedPropertyVersionInModule.get();
        } else {
            String moduleSince = SiteUtil.getSinceVersionFromJavadoc(moduleJavadoc);
            if (moduleSince == null) {
                throw new MacroExecutionException("Missing @since on module " + moduleName);
            }
            String propertySince = null;
            if (propertyJavadoc != null) {
                propertySince = SiteUtil.getSinceVersionFromJavadoc(propertyJavadoc);
            }
            sinceVersion = propertySince != null && SiteUtil.isVersionAtLeast(propertySince, moduleSince) ? propertySince : moduleSince;
        }
        return sinceVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Optional<String> getSpecifiedPropertyVersionInModule(String propertyName, DetailNode moduleJavadoc) throws MacroExecutionException {
        Optional<String> specifiedVersion = Optional.empty();
        Optional<DetailNode> propertyNodeFromModuleJavadoc = SiteUtil.getPropertyJavadocNodeInModule(propertyName, moduleJavadoc);
        if (!propertyNodeFromModuleJavadoc.isPresent()) throw new MacroExecutionException("Property '" + propertyName + "' is not found in module's javadoc.");
        List<DetailNode> propertyModuleTextNodes = SiteUtil.getNodesOfSpecificType(propertyNodeFromModuleJavadoc.get().getChildren(), 10074);
        Optional<String> sinceVersionLine = propertyModuleTextNodes.stream().map(DetailNode::getText).filter(text -> text.startsWith(" Since version")).findFirst();
        if (!sinceVersionLine.isPresent()) return specifiedVersion;
        String sinceVersionText = sinceVersionLine.get();
        int sinceVersionIndex = sinceVersionText.indexOf(46) - 1;
        if (sinceVersionIndex <= 0) throw new MacroExecutionException(sinceVersionText + " has no valid version, at least one '.' is expected.");
        return Optional.of(sinceVersionText.substring(sinceVersionIndex));
    }

    public static Optional<DetailNode> getPropertyJavadocNodeInModule(String propertyName, DetailNode moduleJavadoc) {
        List<DetailNode> htmlElementNodes = SiteUtil.getNodesOfSpecificType(moduleJavadoc.getChildren(), 10001);
        List<DetailNode> ulTags = htmlElementNodes.stream().map(JavadocUtil::getFirstChild).filter(child -> {
            boolean isHtmlTag = child.getType() == 10005;
            DetailNode htmlTagNameNode = JavadocUtil.findFirstToken(JavadocUtil.getFirstChild(child), 100);
            return isHtmlTag && "ul".equals(htmlTagNameNode.getText());
        }).toList();
        DetailNode[] childrenOfUlTags = (DetailNode[])ulTags.stream().flatMap(ulTag -> Arrays.stream(ulTag.getChildren())).toArray(DetailNode[]::new);
        List<DetailNode> innerHtmlElementsOfUlTags = SiteUtil.getNodesOfSpecificType(childrenOfUlTags, 10001);
        List<DetailNode> liTags = innerHtmlElementsOfUlTags.stream().map(JavadocUtil::getFirstChild).filter(tag -> tag.getType() == 10011).toList();
        List<DetailNode> liTagsInlineTexts = liTags.stream().map(liTag -> JavadocUtil.findFirstToken(liTag, 10072)).filter(Objects::nonNull).map(inlineTag -> JavadocUtil.findFirstToken(inlineTag, 10074)).toList();
        return liTagsInlineTexts.stream().filter(text -> text.getText().equals(propertyName)).map(textNode -> textNode.getParent().getParent()).findFirst();
    }

    public static List<DetailNode> getNodesOfSpecificType(DetailNode[] allNodes, int neededType) {
        return Arrays.stream(allNodes).filter(child -> child.getType() == neededType).toList();
    }

    @Nullable
    private static String getSinceVersionFromJavadoc(DetailNode javadoc) {
        DetailNode sinceJavadocTag = SiteUtil.getSinceJavadocTag(javadoc);
        return Optional.ofNullable(sinceJavadocTag).map(tag -> JavadocUtil.findFirstToken(tag, 10068)).map(description -> JavadocUtil.findFirstToken(description, 10074)).map(DetailNode::getText).orElse(null);
    }

    private static DetailNode getSinceJavadocTag(DetailNode javadoc) {
        DetailNode[] children = javadoc.getChildren();
        DetailNode javadocTagWithSince = null;
        for (DetailNode child : children) {
            DetailNode sinceNode;
            if (child.getType() != 10071 || (sinceNode = JavadocUtil.findFirstToken(child, 16)) == null) continue;
            javadocTagWithSince = child;
            break;
        }
        return javadocTagWithSince;
    }

    private static boolean isVersionAtLeast(String actualVersion, String requiredVersion) {
        ModuleDescriptor.Version requiredVersionParsed;
        ModuleDescriptor.Version actualVersionParsed = ModuleDescriptor.Version.parse(actualVersion);
        return actualVersionParsed.compareTo(requiredVersionParsed = ModuleDescriptor.Version.parse(requiredVersion)) >= 0;
    }

    public static String getType(Field field, String propertyName, String moduleName, Object instance) throws MacroExecutionException {
        Class<?> fieldClass = SiteUtil.getFieldClass(field, propertyName, moduleName, instance);
        return Optional.ofNullable(field).map(nonNullField -> nonNullField.getAnnotation(XdocsPropertyType.class)).map(propertyType -> propertyType.value().getDescription()).orElseGet(fieldClass::getSimpleName);
    }

    public static String getDefaultValue(String propertyName, Field field, Object classInstance, String moduleName) throws MacroExecutionException {
        Object value = SiteUtil.getFieldValue(field, classInstance);
        Class<?> fieldClass = SiteUtil.getFieldClass(field, propertyName, moduleName, classInstance);
        Object result = null;
        if (CHARSET.equals(propertyName)) {
            result = "the charset property of the parent <a href=\"https://checkstyle.org/config.html#Checker\">Checker</a> module";
        } else if (classInstance instanceof PropertyCacheFile) {
            result = "null (no cache file)";
        } else if (fieldClass == Boolean.TYPE) {
            result = value.toString();
        } else if (fieldClass == Integer.TYPE) {
            result = value.toString();
        } else if (fieldClass == int[].class) {
            result = SiteUtil.getIntArrayPropertyValue(value);
        } else if (fieldClass == double[].class) {
            result = SiteUtil.removeSquareBrackets(Arrays.toString((double[])value).replace(".0", ""));
            if (((String)result).isEmpty()) {
                result = CURLY_BRACKETS;
            }
        } else if (fieldClass == String[].class) {
            result = SiteUtil.getStringArrayPropertyValue(propertyName, value);
        } else if (fieldClass == URI.class || fieldClass == String.class) {
            if (value != null) {
                result = "\"" + value.toString() + "\"";
            }
        } else if (fieldClass == Pattern.class) {
            if (value != null) {
                result = "\"" + value.toString().replace("\n", "\\n").replace("\t", "\\t").replace("\r", "\\r").replace("\f", "\\f") + "\"";
            }
        } else if (fieldClass == Pattern[].class) {
            result = SiteUtil.getPatternArrayPropertyValue(value);
        } else if (fieldClass.isEnum()) {
            if (value != null) {
                result = value.toString().toLowerCase(Locale.ENGLISH);
            }
        } else if (fieldClass == AccessModifierOption[].class) {
            result = SiteUtil.removeSquareBrackets(Arrays.toString((Object[])value));
        } else {
            String message = String.format(Locale.ROOT, "Unknown property type: %s", fieldClass.getSimpleName());
            throw new MacroExecutionException(message);
        }
        if (result == null) {
            result = "null";
        }
        return result;
    }

    private static String getPatternArrayPropertyValue(Object fieldValue) {
        A[] value = fieldValue;
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            value = collection.stream().map(Pattern.class::cast).toArray(Pattern[]::new);
        }
        String result = "";
        if (value != null && Array.getLength(value) > 0) {
            result = SiteUtil.removeSquareBrackets(Arrays.stream((Pattern[])value).map(Pattern::pattern).collect(Collectors.joining(COMMA_SPACE)));
        }
        if (result.isEmpty()) {
            result = CURLY_BRACKETS;
        }
        return result;
    }

    private static String removeSquareBrackets(String value) {
        return value.replace("[", "").replace("]", "");
    }

    private static String getStringArrayPropertyValue(String propertyName, Object value) {
        String result;
        if (value == null) {
            result = "";
        } else {
            try (Stream<?> valuesStream = SiteUtil.getValuesStream(value);){
                result = valuesStream.map(String.class::cast).sorted().collect(Collectors.joining(COMMA_SPACE));
            }
        }
        if (result.isEmpty()) {
            result = FILE_EXTENSIONS.equals(propertyName) ? "all files" : CURLY_BRACKETS;
        }
        return result;
    }

    private static Stream<?> getValuesStream(Object value) {
        Stream<Object> valuesStream;
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            valuesStream = collection.stream();
        } else {
            Object[] array = (Object[])value;
            valuesStream = Arrays.stream(array);
        }
        return valuesStream;
    }

    private static String getIntArrayPropertyValue(Object value) {
        try (IntStream stream = SiteUtil.getIntStream(value);){
            String result = stream.mapToObj(TokenUtil::getTokenName).sorted().collect(Collectors.joining(COMMA_SPACE));
            if (result.isEmpty()) {
                result = CURLY_BRACKETS;
            }
            String string = result;
            return string;
        }
    }

    private static IntStream getIntStream(Object value) {
        IntStream stream;
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            stream = collection.stream().mapToInt(Integer.TYPE::cast);
        } else {
            stream = value instanceof BitSet ? ((BitSet)value).stream() : Arrays.stream((int[])value);
        }
        return stream;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Class<?> getFieldClass(Field field, String propertyName, String moduleName, Object instance) throws MacroExecutionException {
        void var4_14;
        void var4_8;
        void var4_6;
        Object var4_4 = null;
        if (PROPERTIES_ALLOWED_GET_TYPES_FROM_METHOD.contains(moduleName + DOT + propertyName)) {
            Class<?> clazz = SiteUtil.getPropertyClass(propertyName, instance);
        }
        if (field != null && var4_6 == null) {
            Class<?> clazz = field.getType();
        }
        if (var4_8 == null) {
            throw new MacroExecutionException("Could not find field " + propertyName + " in class " + moduleName);
        }
        if (field != null && (var4_8 == List.class || var4_8 == Set.class)) {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            Class parameterClass = (Class)type.getActualTypeArguments()[0];
            if (parameterClass == Integer.class) {
                return var4_14;
            }
            if (parameterClass == String.class) {
                return var4_14;
            }
            if (parameterClass == Pattern.class) {
                return var4_14;
            }
            String message = "Unknown parameterized type: " + parameterClass.getSimpleName();
            throw new MacroExecutionException(message);
        }
        if (var4_8 != BitSet.class) return var4_14;
        return var4_14;
    }

    public static Class<?> getPropertyClass(String propertyName, Object instance) throws MacroExecutionException {
        Class<?> result;
        try {
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)instance, (String)propertyName);
            result = descriptor.getPropertyType();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exc) {
            throw new MacroExecutionException(exc.getMessage(), (Throwable)exc);
        }
        return result;
    }

    public static List<Integer> getDifference(int[] tokens, int ... subtractions) {
        Set subtractionsSet = Arrays.stream(subtractions).boxed().collect(Collectors.toUnmodifiableSet());
        return Arrays.stream(tokens).boxed().filter(token -> !subtractionsSet.contains(token)).toList();
    }

    public static Field getField(Class<?> fieldClass, String propertyName) {
        Field result = null;
        Class<?> currentClass = fieldClass;
        while (!Object.class.equals(currentClass)) {
            try {
                result = currentClass.getDeclaredField(propertyName);
                result.trySetAccessible();
                break;
            }
            catch (NoSuchFieldException ignored) {
                currentClass = currentClass.getSuperclass();
            }
        }
        return result;
    }

    public static String getLinkToDocument(String moduleName, String document) throws MacroExecutionException {
        Path templatePath = SiteUtil.getTemplatePath(moduleName.replace("Check", ""));
        if (templatePath == null) {
            throw new MacroExecutionException(String.format(Locale.ROOT, "Could not find template for %s", moduleName));
        }
        Path templatePathParent = templatePath.getParent();
        if (templatePathParent == null) {
            throw new MacroExecutionException("Failed to get parent path for " + String.valueOf(templatePath));
        }
        return templatePathParent.relativize(Path.of(SRC, "site/xdoc", document)).toString().replace(".xml", ".html").replace('\\', '/');
    }

    private static final class DescriptionExtractor {
        private DescriptionExtractor() {
        }

        private static String getDescriptionFromJavadoc(DetailNode javadoc, String moduleName) throws MacroExecutionException {
            boolean isInCodeLiteral = false;
            boolean isInHtmlElement = false;
            boolean isInHrefAttribute = false;
            StringBuilder description = new StringBuilder(128);
            ArrayDeque queue = new ArrayDeque();
            List<DetailNode> descriptionNodes = DescriptionExtractor.getDescriptionNodes(javadoc);
            Lists.reverse(descriptionNodes).forEach(queue::push);
            while (!queue.isEmpty()) {
                DetailNode node = (DetailNode)queue.pop();
                Lists.reverse(Arrays.asList(node.getChildren())).forEach(queue::push);
                if (node.getType() == 100 && "href".equals(node.getText())) {
                    isInHrefAttribute = true;
                }
                if (isInHrefAttribute && node.getType() == 89) {
                    String href = node.getText();
                    if (href.contains(SiteUtil.CHECKSTYLE_ORG_URL)) {
                        DescriptionExtractor.handleInternalLink(description, moduleName, href);
                    } else {
                        description.append(href);
                    }
                    isInHrefAttribute = false;
                    continue;
                }
                if (node.getType() == 10001) {
                    isInHtmlElement = true;
                }
                if (node.getType() == 55 && node.getParent().getType() == 10003) {
                    description.append(node.getText());
                    isInHtmlElement = false;
                }
                if (node.getType() == 10074 || isInHtmlElement && node.getChildren().length == 0 && node.getType() != 1) {
                    description.append(node.getText());
                }
                if (node.getType() == 45) {
                    isInCodeLiteral = true;
                    description.append("<code>");
                }
                if (!isInCodeLiteral || node.getType() != 20) continue;
                isInCodeLiteral = false;
                description.append("</code>");
            }
            return description.toString().trim();
        }

        private static void handleInternalLink(StringBuilder description, String moduleName, String value) throws MacroExecutionException {
            String href = value;
            href = href.replace(SiteUtil.CHECKSTYLE_ORG_URL, "");
            href = href.substring(1, href.length() - 1);
            String relativeHref = SiteUtil.getLinkToDocument(moduleName, href);
            int doubleQuote = 34;
            description.append('\"').append(relativeHref).append('\"');
        }

        private static List<DetailNode> getDescriptionNodes(DetailNode javadoc) {
            DetailNode[] children = javadoc.getChildren();
            ArrayList<DetailNode> descriptionNodes = new ArrayList<DetailNode>();
            for (DetailNode child : children) {
                if (DescriptionExtractor.isEndOfDescription(child)) break;
                descriptionNodes.add(child);
            }
            return descriptionNodes;
        }

        private static boolean isEndOfDescription(DetailNode child) {
            DetailNode nextSibling = JavadocUtil.getNextSibling(child);
            DetailNode secondNextSibling = JavadocUtil.getNextSibling(nextSibling);
            DetailNode thirdNextSibling = JavadocUtil.getNextSibling(secondNextSibling);
            return child.getType() == 6 && nextSibling.getType() == 1 && secondNextSibling.getType() == 6 && thirdNextSibling.getType() == 1;
        }
    }
}

