/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Optional;

@StatelessCheck
public class NoWhitespaceAfterCheck
extends AbstractCheck {
    public static final String MSG_KEY = "ws.followed";
    private boolean allowLineBreaks = true;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{29, 170, 129, 130, 31, 32, 131, 132, 59, 17, 24};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{29, 170, 129, 130, 31, 32, 131, 132, 59, 23, 17, 24, 67, 180};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    public void setAllowLineBreaks(boolean allowLineBreaks) {
        this.allowLineBreaks = allowLineBreaks;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int whitespaceLineNo;
        DetailAST whitespaceFollowedAst;
        int whitespaceColumnNo;
        if (NoWhitespaceAfterCheck.shouldCheckWhitespaceAfter(ast) && this.hasTrailingWhitespace(ast, whitespaceColumnNo = NoWhitespaceAfterCheck.getPositionAfter(whitespaceFollowedAst = NoWhitespaceAfterCheck.getWhitespaceFollowedNode(ast)), whitespaceLineNo = whitespaceFollowedAst.getLineNo())) {
            this.log(ast, MSG_KEY, whitespaceFollowedAst.getText());
        }
    }

    private static DetailAST getWhitespaceFollowedNode(DetailAST ast) {
        return switch (ast.getType()) {
            case 23 -> ast.findFirstToken(77);
            case 17 -> NoWhitespaceAfterCheck.getArrayDeclaratorPreviousElement(ast);
            case 24 -> NoWhitespaceAfterCheck.getIndexOpPreviousElement(ast);
            default -> ast;
        };
    }

    private static boolean shouldCheckWhitespaceAfter(DetailAST ast) {
        DetailAST previousSibling = ast.getPreviousSibling();
        boolean isSynchronizedMethod = ast.getType() == 67 && ast.getFirstChild() == null;
        return !isSynchronizedMethod && (previousSibling == null || previousSibling.getType() != 158);
    }

    private static int getPositionAfter(DetailAST ast) {
        int after;
        if (ast.getType() == 58 && ast.getNextSibling() != null && ast.getNextSibling().getType() == 76) {
            DetailAST methodDef = ast.getParent();
            DetailAST endOfParams = methodDef.findFirstToken(77);
            after = endOfParams.getColumnNo() + 1;
        } else {
            after = ast.getColumnNo() + ast.getText().length();
        }
        return after;
    }

    private boolean hasTrailingWhitespace(DetailAST ast, int whitespaceColumnNo, int whitespaceLineNo) {
        int astLineNo = ast.getLineNo();
        int[] line = this.getLineCodePoints(astLineNo - 1);
        boolean result = astLineNo == whitespaceLineNo && whitespaceColumnNo < line.length ? CommonUtil.isCodePointWhitespace(line, whitespaceColumnNo) : !this.allowLineBreaks;
        return result;
    }

    private static DetailAST getArrayDeclaratorPreviousElement(DetailAST ast) {
        DetailAST previousElement;
        if (ast.getPreviousSibling() != null && ast.getPreviousSibling().getType() == 17) {
            previousElement = NoWhitespaceAfterCheck.getPreviousElementOfMultiDimArray(ast);
        } else {
            DetailAST parent = ast.getParent();
            switch (parent.getType()) {
                case 168: 
                case 169: {
                    previousElement = ast.getPreviousSibling();
                    break;
                }
                case 59: 
                case 136: 
                case 164: {
                    previousElement = NoWhitespaceAfterCheck.getTypeLastNode(ast);
                    break;
                }
                case 13: {
                    previousElement = NoWhitespaceAfterCheck.getPreviousNodeWithParentOfTypeAst(ast, parent);
                    break;
                }
                case 180: {
                    DetailAST ident = NoWhitespaceAfterCheck.getIdentLastToken(ast);
                    if (ident == null) {
                        previousElement = ast.getParent().getFirstChild();
                        break;
                    }
                    previousElement = ident;
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected ast syntax " + String.valueOf(parent));
                }
            }
        }
        return previousElement;
    }

    private static DetailAST getPreviousElementOfMultiDimArray(DetailAST leftBracket) {
        DetailAST previousRightBracket = leftBracket.getPreviousSibling().getLastChild();
        DetailAST ident = null;
        DetailAST parent = leftBracket.getParent().getParent();
        while (ident == null) {
            ident = parent.findFirstToken(58);
            parent = parent.getParent();
        }
        DetailAST previousElement = ident.getColumnNo() > previousRightBracket.getColumnNo() && ident.getColumnNo() < leftBracket.getColumnNo() ? ident : previousRightBracket;
        return previousElement;
    }

    private static DetailAST getIndexOpPreviousElement(DetailAST ast) {
        DetailAST result;
        DetailAST firstChild = ast.getFirstChild();
        if (firstChild.getType() == 24) {
            result = firstChild.findFirstToken(48);
        } else if (firstChild.getType() == 58) {
            result = firstChild;
        } else {
            DetailAST ident = NoWhitespaceAfterCheck.getIdentLastToken(ast);
            if (ident == null) {
                DetailAST rparen = ast.findFirstToken(77);
                if (rparen == null) {
                    DetailAST lastChild = firstChild.getLastChild();
                    result = lastChild.findFirstToken(73);
                } else {
                    result = rparen;
                }
            } else {
                result = ident;
            }
        }
        return result;
    }

    private static DetailAST getTypeLastNode(DetailAST ast) {
        DetailAST parent = ast.getParent();
        boolean isPrecededByTypeArgs = parent.findFirstToken(163) != null;
        Optional<DetailAST> objectArrayType = Optional.ofNullable(NoWhitespaceAfterCheck.getIdentLastToken(ast));
        DetailAST typeLastNode = isPrecededByTypeArgs ? parent.findFirstToken(163).findFirstToken(173) : (objectArrayType.isPresent() ? objectArrayType.orElseThrow() : parent.getFirstChild());
        return typeLastNode;
    }

    private static DetailAST getPreviousNodeWithParentOfTypeAst(DetailAST ast, DetailAST parent) {
        DetailAST previousElement;
        DetailAST ident = NoWhitespaceAfterCheck.getIdentLastToken(parent.getParent());
        DetailAST lastTypeNode = NoWhitespaceAfterCheck.getTypeLastNode(ast);
        if (ident == null || ident.getLineNo() > ast.getLineNo()) {
            previousElement = lastTypeNode;
        } else if (ident.getLineNo() < ast.getLineNo()) {
            previousElement = ident;
        } else {
            int instanceOfSize = 13;
            previousElement = ident.getColumnNo() >= ast.getColumnNo() + 2 || lastTypeNode.getColumnNo() >= ident.getColumnNo() + 13 ? lastTypeNode : ident;
        }
        return previousElement;
    }

    private static DetailAST getIdentLastToken(DetailAST ast) {
        DetailAST methodCall;
        Optional<DetailAST> dot = NoWhitespaceAfterCheck.getPrecedingDot(ast);
        DetailAST result = dot.isEmpty() || ast.getFirstChild().getType() == 27 ? ((methodCall = ast.findFirstToken(27)) == null ? ast.findFirstToken(58) : methodCall.findFirstToken(77)) : dot.orElseThrow().getFirstChild().getNextSibling();
        return result;
    }

    private static Optional<DetailAST> getPrecedingDot(DetailAST leftBracket) {
        DetailAST referencedMemberDot = leftBracket.findFirstToken(59);
        Optional<DetailAST> result = Optional.ofNullable(referencedMemberDot);
        return result.or(() -> NoWhitespaceAfterCheck.getReferencedClassDot(leftBracket));
    }

    private static Optional<DetailAST> getReferencedClassDot(DetailAST leftBracket) {
        DetailAST parent = leftBracket.getParent();
        Optional<DetailAST> classDot = Optional.empty();
        if (parent.getType() != 80) {
            classDot = Optional.ofNullable(parent.findFirstToken(59));
        }
        return classDot;
    }
}

