/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.AbstractAutomaticBean;
import com.puppycrawl.tools.checkstyle.PropertyType;
import com.puppycrawl.tools.checkstyle.XdocsPropertyType;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SuppressWithPlainTextCommentFilter
extends AbstractAutomaticBean
implements Filter {
    private static final String DEFAULT_OFF_FORMAT = "// CHECKSTYLE:OFF";
    private static final String DEFAULT_ON_FORMAT = "// CHECKSTYLE:ON";
    private static final String DEFAULT_CHECK_FORMAT = ".*";
    private Pattern offCommentFormat = CommonUtil.createPattern("// CHECKSTYLE:OFF");
    private Pattern onCommentFormat = CommonUtil.createPattern("// CHECKSTYLE:ON");
    @XdocsPropertyType(value=PropertyType.PATTERN)
    private String checkFormat = ".*";
    @XdocsPropertyType(value=PropertyType.PATTERN)
    private String messageFormat;
    @XdocsPropertyType(value=PropertyType.PATTERN)
    private String idFormat;

    public final void setOffCommentFormat(Pattern pattern) {
        this.offCommentFormat = pattern;
    }

    public final void setOnCommentFormat(Pattern pattern) {
        this.onCommentFormat = pattern;
    }

    public final void setCheckFormat(String format) {
        this.checkFormat = format;
    }

    public final void setMessageFormat(String format) {
        this.messageFormat = format;
    }

    public final void setIdFormat(String format) {
        this.idFormat = format;
    }

    @Override
    public boolean accept(AuditEvent event) {
        FileText fileText;
        boolean accepted = true;
        if (event.getViolation() != null && (fileText = SuppressWithPlainTextCommentFilter.getFileText(event.getFileName())) != null) {
            List<Suppression> suppressions = this.getSuppressions(fileText);
            accepted = SuppressWithPlainTextCommentFilter.getNearestSuppression(suppressions, event) == null;
        }
        return accepted;
    }

    @Override
    protected void finishLocalSetup() {
    }

    private static FileText getFileText(String fileName) {
        File file = new File(fileName);
        FileText result = null;
        if (!file.isDirectory()) {
            try {
                result = new FileText(file, StandardCharsets.UTF_8.name());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot read source file: " + fileName, ex);
            }
        }
        return result;
    }

    private List<Suppression> getSuppressions(FileText fileText) {
        ArrayList<Suppression> suppressions = new ArrayList<Suppression>();
        for (int lineNo = 0; lineNo < fileText.size(); ++lineNo) {
            Optional<Suppression> suppression = this.getSuppression(fileText, lineNo);
            suppression.ifPresent(suppressions::add);
        }
        return suppressions;
    }

    private Optional<Suppression> getSuppression(FileText fileText, int lineNo) {
        String line = fileText.get(lineNo);
        Matcher onCommentMatcher = this.onCommentFormat.matcher(line);
        Matcher offCommentMatcher = this.offCommentFormat.matcher(line);
        Suppression suppression = null;
        if (onCommentMatcher.find()) {
            suppression = new Suppression(onCommentMatcher.group(0), lineNo + 1, SuppressionType.ON, this);
        }
        if (offCommentMatcher.find()) {
            suppression = new Suppression(offCommentMatcher.group(0), lineNo + 1, SuppressionType.OFF, this);
        }
        return Optional.ofNullable(suppression);
    }

    private static Suppression getNearestSuppression(Collection<Suppression> suppressions, AuditEvent event) {
        return suppressions.stream().filter(suppression -> suppression.isMatch(event)).reduce((first, second) -> second).filter(suppression -> suppression.suppressionType != SuppressionType.ON).orElse(null);
    }

    private static final class Suppression {
        private final Pattern eventSourceRegexp;
        private final Pattern eventMessageRegexp;
        private final Pattern eventIdRegexp;
        private final int lineNo;
        private final SuppressionType suppressionType;

        private Suppression(String text, int lineNo, SuppressionType suppressionType, SuppressWithPlainTextCommentFilter filter) {
            this.lineNo = lineNo;
            this.suppressionType = suppressionType;
            Pattern commentFormat = this.suppressionType == SuppressionType.ON ? filter.onCommentFormat : filter.offCommentFormat;
            String format = "";
            try {
                format = CommonUtil.fillTemplateWithStringsByRegexp(filter.checkFormat, text, commentFormat);
                this.eventSourceRegexp = Pattern.compile(format);
                if (filter.messageFormat == null) {
                    this.eventMessageRegexp = null;
                } else {
                    format = CommonUtil.fillTemplateWithStringsByRegexp(filter.messageFormat, text, commentFormat);
                    this.eventMessageRegexp = Pattern.compile(format);
                }
                if (filter.idFormat == null) {
                    this.eventIdRegexp = null;
                } else {
                    format = CommonUtil.fillTemplateWithStringsByRegexp(filter.idFormat, text, commentFormat);
                    this.eventIdRegexp = Pattern.compile(format);
                }
            }
            catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("unable to parse expanded comment " + format, ex);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Suppression suppression = (Suppression)other;
            return Objects.equals(this.lineNo, suppression.lineNo) && Objects.equals((Object)this.suppressionType, (Object)suppression.suppressionType) && Objects.equals(this.eventSourceRegexp, suppression.eventSourceRegexp) && Objects.equals(this.eventMessageRegexp, suppression.eventMessageRegexp) && Objects.equals(this.eventIdRegexp, suppression.eventIdRegexp);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.lineNo, this.suppressionType, this.eventSourceRegexp, this.eventMessageRegexp, this.eventIdRegexp});
        }

        private boolean isMatch(AuditEvent event) {
            return this.isInScopeOfSuppression(event) && this.isCheckMatch(event) && this.isIdMatch(event) && this.isMessageMatch(event);
        }

        private boolean isInScopeOfSuppression(AuditEvent event) {
            return this.lineNo <= event.getLine();
        }

        private boolean isCheckMatch(AuditEvent event) {
            Matcher checkMatcher = this.eventSourceRegexp.matcher(event.getSourceName());
            return checkMatcher.find();
        }

        private boolean isIdMatch(AuditEvent event) {
            boolean match = true;
            if (this.eventIdRegexp != null) {
                if (event.getModuleId() == null) {
                    match = false;
                } else {
                    Matcher idMatcher = this.eventIdRegexp.matcher(event.getModuleId());
                    match = idMatcher.find();
                }
            }
            return match;
        }

        private boolean isMessageMatch(AuditEvent event) {
            boolean match = true;
            if (this.eventMessageRegexp != null) {
                Matcher messageMatcher = this.eventMessageRegexp.matcher(event.getMessage());
                match = messageMatcher.find();
            }
            return match;
        }
    }

    private static enum SuppressionType {
        ON,
        OFF;

    }
}

