/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.LineColumn;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FileStatefulCheck
public class RegexpCheck
extends AbstractCheck {
    public static final String MSG_ILLEGAL_REGEXP = "illegal.regexp";
    public static final String MSG_REQUIRED_REGEXP = "required.regexp";
    public static final String MSG_DUPLICATE_REGEXP = "duplicate.regexp";
    private static final int DEFAULT_DUPLICATE_LIMIT = -1;
    private static final int DEFAULT_ERROR_LIMIT = 100;
    private static final String ERROR_LIMIT_EXCEEDED_MESSAGE = "The error limit has been exceeded, the check is aborting, there may be more unreported errors.";
    private String message;
    private boolean ignoreComments;
    private boolean illegalPattern;
    private int errorLimit = 100;
    private int duplicateLimit;
    private boolean checkForDuplicates;
    private Pattern format = Pattern.compile("^$", 8);

    public void setMessage(String message) {
        this.message = message;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public void setIllegalPattern(boolean illegalPattern) {
        this.illegalPattern = illegalPattern;
    }

    public void setErrorLimit(int errorLimit) {
        this.errorLimit = errorLimit;
    }

    public void setDuplicateLimit(int duplicateLimit) {
        this.duplicateLimit = duplicateLimit;
        this.checkForDuplicates = duplicateLimit > -1;
    }

    public final void setFormat(Pattern pattern) {
        this.format = CommonUtil.createPattern(pattern.pattern(), 8);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.processRegexpMatches();
    }

    private void processRegexpMatches() {
        Matcher matcher = this.format.matcher(this.getFileContents().getText().getFullText());
        int errorCount = 0;
        int matchCount = 0;
        FileText text = this.getFileContents().getText();
        while (errorCount < this.errorLimit && matcher.find()) {
            LineColumn start = text.lineColumn(matcher.start());
            int startLine = start.getLine();
            boolean ignore = this.isIgnore(startLine, text, start, matcher);
            if (ignore || !this.illegalPattern && (!this.checkForDuplicates || ++matchCount - 1 <= this.duplicateLimit)) continue;
            this.logMessage(startLine, ++errorCount);
        }
        if (!this.illegalPattern && matchCount == 0) {
            String msg = this.getMessage(errorCount);
            this.log(1, MSG_REQUIRED_REGEXP, msg);
        }
    }

    private boolean isIgnore(int startLine, FileText text, LineColumn start, Matcher matcher) {
        LineColumn end = matcher.end() == 0 ? text.lineColumn(0) : text.lineColumn(matcher.end() - 1);
        boolean ignore = false;
        if (this.ignoreComments) {
            FileContents theFileContents = this.getFileContents();
            int startColumn = start.getColumn();
            int endLine = end.getLine();
            int endColumn = end.getColumn();
            ignore = theFileContents.hasIntersectionWithComment(startLine, startColumn, endLine, endColumn);
        }
        return ignore;
    }

    private void logMessage(int lineNumber, int errorCount) {
        String msg = this.getMessage(errorCount);
        if (this.illegalPattern) {
            this.log(lineNumber, MSG_ILLEGAL_REGEXP, msg);
        } else {
            this.log(lineNumber, MSG_DUPLICATE_REGEXP, msg);
        }
    }

    private String getMessage(int errorCount) {
        Object msg = this.message == null || this.message.isEmpty() ? this.format.pattern() : this.message;
        if (errorCount >= this.errorLimit) {
            msg = ERROR_LIMIT_EXCEEDED_MESSAGE + (String)msg;
        }
        return msg;
    }
}

