/*
 * Decompiled with CFR 0.152.
 */
package com.pswidersk.gradle.python;

import com.pswidersk.gradle.python.PythonPluginExtension;
import com.pswidersk.gradle.python.PythonPluginUtilsKt;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0007J%\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010J%\u0010\u0011\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/pswidersk/gradle/python/CondaSetupTask;", "Lorg/gradle/api/DefaultTask;", "execOperations", "Lorg/gradle/process/ExecOperations;", "<init>", "(Lorg/gradle/process/ExecOperations;)V", "pythonPluginExtension", "Lcom/pswidersk/gradle/python/PythonPluginExtension;", "setup", "", "runOnWindows", "Lorg/gradle/process/ExecResult;", "kotlin.jvm.PlatformType", "condaInstaller", "Ljava/io/File;", "condaDirFile", "(Ljava/io/File;Ljava/io/File;)Lorg/gradle/process/ExecResult;", "runOnUnix", "python-gradle-plugin"})
public abstract class CondaSetupTask
extends DefaultTask {
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    private final PythonPluginExtension pythonPluginExtension;

    @Inject
    public CondaSetupTask(@NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.execOperations = execOperations;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.pythonPluginExtension = PythonPluginUtilsKt.getPythonPlugin(project);
        this.setGroup("python");
        this.setDescription("Setup " + this.pythonPluginExtension.getCondaInstaller().get());
        this.onlyIf(arg_0 -> CondaSetupTask._init_$lambda$1(arg_0 -> CondaSetupTask._init_$lambda$0(this, arg_0), arg_0));
    }

    @TaskAction
    public final void setup() {
        ExecResult execResult;
        PythonPluginExtension $this$setup_u24lambda_u242 = this.pythonPluginExtension;
        boolean bl = false;
        File condaDirFile = ((Directory)$this$setup_u24lambda_u242.getCondaDir$python_gradle_plugin().get()).getAsFile();
        File condaInstaller = ((RegularFile)$this$setup_u24lambda_u242.getCondaInstallerFile$python_gradle_plugin().get()).getAsFile();
        this.getLogger().lifecycle("Installing " + $this$setup_u24lambda_u242.getCondaInstaller().get() + "...");
        if (PythonPluginUtilsKt.isWindows()) {
            Intrinsics.checkNotNull((Object)condaInstaller);
            Intrinsics.checkNotNull((Object)condaDirFile);
            execResult = this.runOnWindows(condaInstaller, condaDirFile);
        } else {
            Intrinsics.checkNotNull((Object)condaInstaller);
            Intrinsics.checkNotNull((Object)condaDirFile);
            execResult = this.runOnUnix(condaInstaller, condaDirFile);
        }
    }

    private final ExecResult runOnWindows(File condaInstaller, File condaDirFile) {
        return this.execOperations.exec(arg_0 -> CondaSetupTask.runOnWindows$lambda$4(arg_0 -> CondaSetupTask.runOnWindows$lambda$3(condaInstaller, condaDirFile, arg_0), arg_0));
    }

    private final ExecResult runOnUnix(File condaInstaller, File condaDirFile) {
        return this.execOperations.exec(arg_0 -> CondaSetupTask.runOnUnix$lambda$6(arg_0 -> CondaSetupTask.runOnUnix$lambda$5(condaInstaller, condaDirFile, arg_0), arg_0));
    }

    private static final boolean _init_$lambda$0(CondaSetupTask this$0, Task it) {
        return !((Directory)this$0.pythonPluginExtension.getCondaBinDir$python_gradle_plugin().get()).getAsFile().exists();
    }

    private static final boolean _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit runOnWindows$lambda$3(File $condaInstaller, File $condaDirFile, ExecSpec it) {
        Object[] objectArray = new String[]{"cmd", "/c", "start", "/wait", $condaInstaller.getCanonicalPath(), "/InstallationType=JustMe", "/RegisterPython=0", "/AddToPath=0", "/S", "/D=" + $condaDirFile.getCanonicalPath()};
        List cmdArgs = CollectionsKt.listOf((Object[])objectArray);
        it.commandLine((Iterable)cmdArgs);
        return Unit.INSTANCE;
    }

    private static final void runOnWindows$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit runOnUnix$lambda$5(File $condaInstaller, File $condaDirFile, ExecSpec it) {
        it.setExecutable($condaInstaller.getCanonicalPath());
        Object[] objectArray = new String[]{"-b", "-u", "-p", $condaDirFile.getCanonicalPath()};
        List execArgs = CollectionsKt.listOf((Object[])objectArray);
        it.args((Iterable)execArgs);
        return Unit.INSTANCE;
    }

    private static final void runOnUnix$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

