/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.Validate;

public class SwiftMessageComparator
implements Comparator<SwiftMessage> {
    private static final transient Logger log = Logger.getLogger(SwiftMessageComparator.class.getName());
    protected boolean ignoreEolsInMultiline = false;
    protected boolean ignoreHeaderSession = false;
    protected boolean ignoreTrailer = false;
    private List<String> tagnamesToIgnore = new ArrayList<String>();

    @Override
    public int compare(SwiftMessage m1, SwiftMessage m2) {
        Validate.notNull((Object)m1);
        Validate.notNull((Object)m2);
        boolean b1 = this.compareB1(m1.getBlock1(), m2.getBlock1());
        boolean b2 = this.compareB2(m1.getBlock2(), m2.getBlock2());
        boolean b3 = this.compareTagListBlock(m1.getBlock3(), m2.getBlock3());
        boolean b4 = this.compareTagListBlock(m1.getBlock4(), m2.getBlock4());
        boolean b5 = this.ignoreTrailer || this.compareTagListBlock(m1.getBlock5(), m2.getBlock5());
        log.fine("b1=" + b1 + ", b2=" + b2 + ", b3=" + b3 + ", b4=" + b4 + ", b5=" + b5);
        return b1 && b2 && b3 && b4 && b5 ? 0 : 1;
    }

    public boolean compareB2(SwiftBlock2 o1, SwiftBlock2 o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!o1.getClass().equals(o2.getClass())) {
            return false;
        }
        return StringUtils.equals((String)o1.getValue(), (String)o2.getValue());
    }

    public boolean compareTagListBlock(SwiftTagListBlock o1, SwiftTagListBlock o2) {
        if (SwiftMessageComparator.isBlank(o1) && SwiftMessageComparator.isBlank(o2)) {
            return true;
        }
        if (SwiftMessageComparator.isBlank(o1) || SwiftMessageComparator.isBlank(o2)) {
            return false;
        }
        if (o1.size() != o2.size()) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < o1.size(); ++i) {
            Tag t1 = o1.getTag(i);
            Tag t2 = o2.getTag(i);
            if (this.tagNameIgnored(t1.getName(), t2.getName())) {
                log.finer("Tag ignored: " + t1.getName() + " - " + t2.getName());
                continue;
            }
            if (StringUtils.equals((String)t1.getName(), (String)t2.getName()) && this.valuesAreEqual(t1.getValue(), t2.getValue())) continue;
            ++count;
        }
        return count <= 0;
    }

    private static boolean isBlank(SwiftTagListBlock b) {
        return b == null || b.isEmpty();
    }

    private boolean valuesAreEqual(String value1, String value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        if (this.ignoreEolsInMultiline) {
            BufferedReader br1 = new BufferedReader(new StringReader(value1));
            BufferedReader br2 = new BufferedReader(new StringReader(value2));
            try {
                String l2;
                String l1;
                do {
                    if (StringUtils.equals((String)(l1 = br1.readLine()), (String)(l2 = br2.readLine()))) continue;
                    return false;
                } while (l1 != null || l2 != null);
                return true;
            }
            catch (IOException e) {
                throw new UnhandledException((Throwable)e);
            }
        }
        return StringUtils.equals((String)value1, (String)value2);
    }

    private boolean tagNameIgnored(String name1, String name2) {
        if (this.tagnamesToIgnore != null && !this.tagnamesToIgnore.isEmpty()) {
            for (String name : this.tagnamesToIgnore) {
                if (!StringUtils.equals((String)name, (String)name1) && !StringUtils.equals((String)name, (String)name2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean compareB1(SwiftBlock1 b1, SwiftBlock1 b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        boolean session = this.ignoreHeaderSession || StringUtils.equals((String)b1.getSessionNumber(), (String)b2.getSessionNumber());
        boolean sequence = this.ignoreHeaderSession || StringUtils.equals((String)b1.getSequenceNumber(), (String)b2.getSequenceNumber());
        return session && sequence && StringUtils.equals((String)b1.getApplicationId(), (String)b2.getApplicationId()) && StringUtils.equals((String)b1.getLogicalTerminal(), (String)b2.getLogicalTerminal()) && StringUtils.equals((String)b1.getServiceId(), (String)b2.getServiceId());
    }

    public boolean isIgnoreEolsInMultiline() {
        return this.ignoreEolsInMultiline;
    }

    public void setIgnoreEolsInMultiline(boolean ignoreEolsInMultiline) {
        this.ignoreEolsInMultiline = ignoreEolsInMultiline;
    }

    public List<String> getTagnamesToIgnore() {
        return this.tagnamesToIgnore;
    }

    public void setTagnamesToIgnore(List<String> tagnamesToIgnore) {
        this.tagnamesToIgnore = tagnamesToIgnore;
    }

    public boolean addTagnameToIgnore(String o) {
        return this.tagnamesToIgnore.add(o);
    }

    public boolean isIgnoreHeaderSession() {
        return this.ignoreHeaderSession;
    }

    public void setIgnoreHeaderSession(boolean ignoreHeaderSession) {
        this.ignoreHeaderSession = ignoreHeaderSession;
    }

    public boolean isIgnoreTrailer() {
        return this.ignoreTrailer;
    }

    public void setIgnoreTrailer(boolean ignoreTrailer) {
        this.ignoreTrailer = ignoreTrailer;
    }
}

