/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.CopyableTo;
import com.prowidesoftware.swift.io.parser.MxParser;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.mx.XmlEventWriter;
import com.prowidesoftware.swift.model.mx.dic.ApplicationHeader;
import com.prowidesoftware.swift.model.mx.dic.BranchAndFinancialInstitutionIdentification5;
import com.prowidesoftware.swift.model.mx.dic.BusinessApplicationHeaderV01;
import com.prowidesoftware.swift.model.mx.dic.FinancialInstitutionIdentification8;
import com.prowidesoftware.swift.model.mx.dic.Party9Choice;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BusinessHeader {
    private static final transient Logger log = Logger.getLogger(BusinessHeader.class.getName());
    private ApplicationHeader applicationHeader;
    private BusinessApplicationHeaderV01 businessApplicationHeader;
    public static final transient String NAMESPACE_AH = "urn:swift:xsd:$ahV10";
    public static final transient String NAMESPACE_BAH = "urn:iso:std:iso:20022:tech:xsd:head.001.001.01";

    public BusinessHeader() {
    }

    public BusinessHeader(ApplicationHeader applicationHeader) {
        this();
        this.applicationHeader = applicationHeader;
    }

    public BusinessHeader(BusinessApplicationHeaderV01 businessApplicationHeader) {
        this();
        this.businessApplicationHeader = businessApplicationHeader;
    }

    public ApplicationHeader getApplicationHeader() {
        return this.applicationHeader;
    }

    public void setApplicationHeader(ApplicationHeader applicationHeader) {
        if (this.businessApplicationHeader != null) {
            throw new IllegalStateException("can't set applicationHeader when businessApplicationHeader is not null, set it to null before. These attributes overlap each other");
        }
        this.applicationHeader = applicationHeader;
    }

    public BusinessApplicationHeaderV01 getBusinessApplicationHeader() {
        return this.businessApplicationHeader;
    }

    public void setBusinessApplicationHeader(BusinessApplicationHeaderV01 businessApplicationHeader) {
        if (this.applicationHeader != null) {
            throw new IllegalStateException("can't set businessApplicationHeader when applicationHeader is not null, set it to null before. These attributes overlap each other");
        }
        this.businessApplicationHeader = businessApplicationHeader;
    }

    public String from() {
        if (this.applicationHeader == null) {
            if (this.businessApplicationHeader == null) {
                return null;
            }
            return this.getBIC(this.businessApplicationHeader.getFr());
        }
        try {
            if (StringUtils.equals((String)this.applicationHeader.getFrom().getType(), (String)"BIC")) {
                return this.applicationHeader.getFrom().getId();
            }
            return MxParser.getBICFromDN(this.applicationHeader.getFrom().getId());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public String to() {
        if (this.applicationHeader == null) {
            if (this.businessApplicationHeader == null) {
                return null;
            }
            return this.getBIC(this.businessApplicationHeader.getTo());
        }
        try {
            if (StringUtils.equals((String)this.applicationHeader.getTo().getType(), (String)"BIC")) {
                return this.applicationHeader.getTo().getId();
            }
            return MxParser.getBICFromDN(this.applicationHeader.getTo().getId());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private String getBIC(Party9Choice p) {
        try {
            String found = p.getFIId().getFinInstnId().getBICFI();
            if (!StringUtils.isEmpty((String)found)) {
                return found;
            }
        }
        catch (NullPointerException e) {
            try {
                String found = p.getOrgId().getId().getOrgId().getAnyBIC();
                if (!StringUtils.isEmpty((String)found)) {
                    return found;
                }
            }
            catch (NullPointerException e2) {
                return null;
            }
        }
        return null;
    }

    public String reference() {
        if (this.applicationHeader == null) {
            if (this.businessApplicationHeader == null) {
                return null;
            }
            return this.businessApplicationHeader.getBizMsgIdr();
        }
        return this.applicationHeader.getMsgRef();
    }

    public String xml() {
        return this.xml(null, false);
    }

    public String xml(String prefix, boolean includeXMLDeclaration) {
        CopyableTo<BusinessApplicationHeaderV01> header;
        if (this.businessApplicationHeader != null) {
            header = this.businessApplicationHeader;
        } else if (this.applicationHeader != null) {
            header = this.applicationHeader;
        } else {
            return null;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{header.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)this._element(header), (XMLEventWriter)new XmlEventWriter(sw, prefix, includeXMLDeclaration, "AppHdr"));
            return sw.getBuffer().toString();
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, "Error writing XML:" + (Object)((Object)e) + "\n for header: " + header);
            return null;
        }
    }

    public Element element() {
        CopyableTo<BusinessApplicationHeaderV01> header;
        if (this.businessApplicationHeader != null) {
            header = this.businessApplicationHeader;
        } else if (this.applicationHeader != null) {
            header = this.applicationHeader;
        } else {
            return null;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{header.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            DOMResult res = new DOMResult();
            marshaller.marshal((Object)this._element(header), (Result)res);
            Document doc = (Document)res.getNode();
            return (Element)doc.getFirstChild();
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, "Error writing XML:" + (Object)((Object)e) + "\n for header: " + header);
            return null;
        }
    }

    private JAXBElement _element(Object header) {
        if (header instanceof BusinessApplicationHeaderV01) {
            return new JAXBElement(new QName(NAMESPACE_BAH, "AppHdr"), header.getClass(), null, header);
        }
        if (header instanceof ApplicationHeader) {
            return new JAXBElement(new QName(NAMESPACE_AH, "AppHdr"), header.getClass(), null, header);
        }
        return null;
    }

    public static BusinessHeader create(String sender, String receiver, String reference, MxId id) {
        BusinessHeader h = new BusinessHeader();
        h.setBusinessApplicationHeader(new BusinessApplicationHeaderV01());
        if (sender != null) {
            h.getBusinessApplicationHeader().setFr(new Party9Choice());
            h.getBusinessApplicationHeader().getFr().setFIId(new BranchAndFinancialInstitutionIdentification5());
            h.getBusinessApplicationHeader().getFr().getFIId().setFinInstnId(new FinancialInstitutionIdentification8());
            h.getBusinessApplicationHeader().getFr().getFIId().getFinInstnId().setBICFI(sender);
        }
        if (receiver != null) {
            h.getBusinessApplicationHeader().setTo(new Party9Choice());
            h.getBusinessApplicationHeader().getTo().setFIId(new BranchAndFinancialInstitutionIdentification5());
            h.getBusinessApplicationHeader().getTo().getFIId().setFinInstnId(new FinancialInstitutionIdentification8());
            h.getBusinessApplicationHeader().getTo().getFIId().getFinInstnId().setBICFI(receiver);
        }
        if (reference != null) {
            h.getBusinessApplicationHeader().setBizMsgIdr(reference);
        }
        if (id != null) {
            h.getBusinessApplicationHeader().setMsgDefIdr(id.id());
        }
        h.getBusinessApplicationHeader().setCreDt(BusinessHeader.now());
        return h;
    }

    public void setCreationDate(boolean overwrite) {
        if (this.businessApplicationHeader != null && (this.businessApplicationHeader.getCreDt() == null || overwrite)) {
            this.businessApplicationHeader.setCreDt(BusinessHeader.now());
        } else if (this.applicationHeader != null && (this.applicationHeader.getCrDate() == null || overwrite)) {
            this.applicationHeader.setCrDate(BusinessHeader.now());
        }
    }

    private static XMLGregorianCalendar now() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime());
        XMLGregorianCalendar creationDate = null;
        try {
            creationDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(c.getTime()));
        }
        catch (DatatypeConfigurationException e) {
            log.log(Level.WARNING, "error initializing header creation date", e);
        }
        return creationDate;
    }
}

